package io.github.vigoo.zioaws.budgets
import java.time.Instant
import io.github.vigoo.zioaws.budgets.model.primitives.{
  User,
  GenericString,
  InstanceId,
  Group,
  TargetId,
  Role
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type AccountId = String
    type ActionId = String
    type BudgetName = String
    type GenericString = String
    type GenericTimestamp = Instant
    type Group = String
    type InstanceId = String
    type MaxResults = Int
    type NotificationThreshold = Double
    type NullableBoolean = Boolean
    type NumericValue = String
    type PolicyArn = String
    type PolicyId = String
    type Region = String
    type Role = String
    type RoleArn = String
    type SubscriberAddress = String
    type TargetId = String
    type UnitValue = String
    type User = String
  }
  type ActionHistories =
    List[io.github.vigoo.zioaws.budgets.model.ActionHistory]
  type Actions = List[io.github.vigoo.zioaws.budgets.model.Action]
  type BudgetedAndActualAmountsList =
    List[io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts]
  type Budgets = List[io.github.vigoo.zioaws.budgets.model.Budget]
  type CostFilters = Map[GenericString, Iterable[GenericString]]
  type DimensionValues = List[GenericString]
  type Groups = List[Group]
  type InstanceIds = List[InstanceId]
  type NotificationWithSubscribersList =
    List[io.github.vigoo.zioaws.budgets.model.NotificationWithSubscribers]
  type Notifications = List[io.github.vigoo.zioaws.budgets.model.Notification]
  type PlannedBudgetLimits =
    Map[GenericString, io.github.vigoo.zioaws.budgets.model.Spend]
  type Roles = List[Role]
  type Subscribers = List[io.github.vigoo.zioaws.budgets.model.Subscriber]
  type TargetIds = List[TargetId]
  type Users = List[User]
}
