package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionType {
  def unwrap: software.amazon.awssdk.services.budgets.model.SubscriptionType
}
object SubscriptionType {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.SubscriptionType
  ): io.github.vigoo.zioaws.budgets.model.SubscriptionType = value match {
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.SNS =>
      val r = SNS
      r
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.SubscriptionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.SubscriptionType =
      software.amazon.awssdk.services.budgets.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SNS
      extends io.github.vigoo.zioaws.budgets.model.SubscriptionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.SubscriptionType =
      software.amazon.awssdk.services.budgets.model.SubscriptionType.SNS
  }
  case object EMAIL
      extends io.github.vigoo.zioaws.budgets.model.SubscriptionType {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.SubscriptionType =
      software.amazon.awssdk.services.budgets.model.SubscriptionType.EMAIL
  }
}
