package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetPerformanceHistoryResponse(
    budgetPerformanceHistory: Option[
      io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse = {
    import DescribeBudgetPerformanceHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
      .builder()
      .optionallyWith(
        budgetPerformanceHistory.map(value => value.buildAwsValue())
      )(_.budgetPerformanceHistory)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetPerformanceHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetPerformanceHistoryResponse(
          budgetPerformanceHistoryValue.map(value => value.editable),
          nextTokenValue.map(value => value)
        )
    def budgetPerformanceHistoryValue: Option[
      io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly
    ]
    def nextTokenValue: Option[GenericString]
    def budgetPerformanceHistory: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly
    ] = AwsError.unwrapOptionField(
      "budgetPerformanceHistory",
      budgetPerformanceHistoryValue
    )
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly {
    override def budgetPerformanceHistoryValue: Option[
      io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly
    ] = scala
      .Option(impl.budgetPerformanceHistory())
      .map(value =>
        io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory
          .wrap(value)
      )
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
