package io.github.vigoo.zioaws.budgets.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  GenericString,
  MaxResults,
  BudgetName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionsForBudgetRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest = {
    import DescribeBudgetActionsForBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetRequest
      .wrap(buildAwsValue())
}
object DescribeBudgetActionsForBudgetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetRequest =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetActionsForBudgetRequest(
          accountIdValue,
          budgetNameValue,
          maxResultsValue.map(value => value),
          nextTokenValue.map(value => value)
        )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def maxResultsValue: Option[MaxResults]
    def nextTokenValue: Option[GenericString]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionsForBudgetRequest.ReadOnly =
    new Wrapper(impl)
}
