package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.{BudgetName, AccountId}
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberRequest(
    accountId: AccountId,
    budgetName: BudgetName,
    notification: io.github.vigoo.zioaws.budgets.model.Notification,
    subscriber: io.github.vigoo.zioaws.budgets.model.Subscriber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest = {
    import CreateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .budgetName(budgetName: java.lang.String)
      .notification(notification.buildAwsValue())
      .subscriber(subscriber.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest
      .wrap(buildAwsValue())
}
object CreateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest =
      io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest(
        accountIdValue,
        budgetNameValue,
        notificationValue.editable,
        subscriberValue.editable
      )
    def accountIdValue: AccountId
    def budgetNameValue: BudgetName
    def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    def subscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = ZIO.succeed(notificationValue)
    def subscriber: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ] = ZIO.succeed(subscriberValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest
  ) extends io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def budgetNameValue: BudgetName = impl.budgetName(): BudgetName
    override def notificationValue
        : io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Notification
        .wrap(impl.notification())
    override def subscriberValue
        : io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(impl.subscriber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest
  ): io.github.vigoo.zioaws.budgets.model.CreateSubscriberRequest.ReadOnly =
    new Wrapper(impl)
}
