package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.budgets.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.budgets.model.ComparisonOperator
  ): io.github.vigoo.zioaws.budgets.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.budgets.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ComparisonOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.budgets.model.ComparisonOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.budgets.model.ComparisonOperator.EQUAL_TO =>
      val r = EQUAL_TO
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.budgets.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ComparisonOperator =
      software.amazon.awssdk.services.budgets.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object GREATER_THAN
      extends io.github.vigoo.zioaws.budgets.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ComparisonOperator =
      software.amazon.awssdk.services.budgets.model.ComparisonOperator.GREATER_THAN
  }
  case object LESS_THAN
      extends io.github.vigoo.zioaws.budgets.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ComparisonOperator =
      software.amazon.awssdk.services.budgets.model.ComparisonOperator.LESS_THAN
  }
  case object EQUAL_TO
      extends io.github.vigoo.zioaws.budgets.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.budgets.model.ComparisonOperator =
      software.amazon.awssdk.services.budgets.model.ComparisonOperator.EQUAL_TO
  }
}
