package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.budgets.model.primitives.NotificationThreshold
import scala.jdk.CollectionConverters.*
final case class ActionThreshold(
    actionThresholdValue: NotificationThreshold,
    actionThresholdType: io.github.vigoo.zioaws.budgets.model.ThresholdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.ActionThreshold = {
    import ActionThreshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ActionThreshold
      .builder()
      .actionThresholdValue(actionThresholdValue: java.lang.Double)
      .actionThresholdType(actionThresholdType.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.ActionThreshold.wrap(buildAwsValue())
}
object ActionThreshold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.ActionThreshold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.ActionThreshold =
      io.github.vigoo.zioaws.budgets.model
        .ActionThreshold(actionThresholdValueValue, actionThresholdTypeValue)
    def actionThresholdValueValue: NotificationThreshold
    def actionThresholdTypeValue
        : io.github.vigoo.zioaws.budgets.model.ThresholdType
    def actionThresholdValue: ZIO[Any, Nothing, NotificationThreshold] =
      ZIO.succeed(actionThresholdValueValue)
    def actionThresholdType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.ThresholdType
    ] = ZIO.succeed(actionThresholdTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.ActionThreshold
  ) extends io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly {
    override def actionThresholdValueValue: NotificationThreshold =
      impl.actionThresholdValue(): NotificationThreshold
    override def actionThresholdTypeValue
        : io.github.vigoo.zioaws.budgets.model.ThresholdType =
      io.github.vigoo.zioaws.budgets.model.ThresholdType
        .wrap(impl.actionThresholdType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.ActionThreshold
  ): io.github.vigoo.zioaws.budgets.model.ActionThreshold.ReadOnly =
    new Wrapper(impl)
}
