package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import io.github.vigoo.zioaws.budgets.Budgets
import io.github.vigoo.zioaws.budgets.model.{
  CreateBudgetActionRequest,
  CreateSubscriberRequest,
  DeleteBudgetRequest,
  DeleteNotificationRequest,
  UpdateBudgetActionRequest,
  DeleteBudgetActionRequest,
  CreateNotificationRequest,
  DescribeBudgetRequest,
  DescribeBudgetActionsForAccountRequest,
  DeleteSubscriberRequest,
  DescribeNotificationsForBudgetRequest,
  DescribeBudgetActionsForBudgetRequest,
  UpdateSubscriberRequest,
  UpdateBudgetRequest,
  DescribeBudgetActionRequest,
  DescribeBudgetActionHistoriesRequest,
  UpdateNotificationRequest,
  DescribeSubscribersForNotificationRequest,
  ExecuteBudgetActionRequest,
  CreateBudgetRequest,
  DescribeBudgetPerformanceHistoryRequest,
  DescribeBudgetsRequest
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import software.amazon.awssdk.services.budgets.model.{
  UpdateBudgetActionResponse,
  Action,
  DescribeBudgetsResponse,
  CreateNotificationResponse,
  CreateBudgetResponse,
  DeleteBudgetActionResponse,
  DescribeBudgetActionHistoriesResponse,
  DescribeBudgetResponse,
  DescribeSubscribersForNotificationResponse,
  UpdateNotificationResponse,
  UpdateSubscriberResponse,
  DescribeNotificationsForBudgetResponse,
  CreateSubscriberResponse,
  ExecuteBudgetActionResponse,
  ActionHistory,
  DescribeBudgetPerformanceHistoryResponse,
  DescribeBudgetActionsForBudgetResponse,
  DeleteSubscriberResponse,
  Subscriber,
  Budget,
  UpdateBudgetResponse,
  DescribeBudgetActionResponse,
  CreateBudgetActionResponse,
  DescribeBudgetActionsForAccountResponse,
  DeleteBudgetResponse,
  DeleteNotificationResponse,
  Notification
}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.budgets.{
  BudgetsAsyncClientBuilder,
  BudgetsAsyncClient
}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
package object budgets {
  import scala.jdk.CollectionConverters.*
  type Budgets = Has[Budgets.Service]
  object Budgets {
    trait Service extends AspectSupport[Service] {
      val api: BudgetsAsyncClient
      def describeBudgetAction(request: DescribeBudgetActionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly
      ]
      def deleteBudget(request: DeleteBudgetRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.ReadOnly
      ]
      def createBudget(request: CreateBudgetRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.ReadOnly
      ]
      def deleteSubscriber(request: DeleteSubscriberRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.ReadOnly
      ]
      def describeSubscribersForNotification(
          request: DescribeSubscribersForNotificationRequest
      ): ZStream[Any, AwsError, ReadOnly]
      def updateNotification(request: UpdateNotificationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.ReadOnly
      ]
      def deleteBudgetAction(request: DeleteBudgetActionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.ReadOnly
      ]
      def deleteNotification(request: DeleteNotificationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.ReadOnly
      ]
      def describeBudgetActionsForBudget(
          request: DescribeBudgetActionsForBudgetRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
      ]
      def updateBudget(request: UpdateBudgetRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.ReadOnly
      ]
      def createBudgetAction(request: CreateBudgetActionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.ReadOnly
      ]
      def describeBudget(request: DescribeBudgetRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly
      ]
      def describeBudgetPerformanceHistory(
          request: DescribeBudgetPerformanceHistoryRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly
      ]
      def createNotification(request: CreateNotificationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.ReadOnly
      ]
      def updateSubscriber(request: UpdateSubscriberRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.ReadOnly
      ]
      def executeBudgetAction(request: ExecuteBudgetActionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.ReadOnly
      ]
      def describeBudgets(request: DescribeBudgetsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
      ]
      def describeBudgetActionsForAccount(
          request: DescribeBudgetActionsForAccountRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
      ]
      def createSubscriber(request: CreateSubscriberRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.ReadOnly
      ]
      def updateBudgetAction(request: UpdateBudgetActionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly
      ]
      def describeNotificationsForBudget(
          request: DescribeNotificationsForBudgetRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
      ]
      def describeBudgetActionHistories(
          request: DescribeBudgetActionHistoriesRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
      ]
    }
    object BudgetsMock extends Mock[Budgets] {
      object DescribeBudgetAction
          extends Effect[
            DescribeBudgetActionRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly
          ]
      object DeleteBudget
          extends Effect[
            DeleteBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.ReadOnly
          ]
      object CreateBudget
          extends Effect[
            CreateBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.ReadOnly
          ]
      object DeleteSubscriber
          extends Effect[
            DeleteSubscriberRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.ReadOnly
          ]
      object DescribeSubscribersForNotification
          extends Stream[
            DescribeSubscribersForNotificationRequest,
            AwsError,
            ReadOnly
          ]
      object UpdateNotification
          extends Effect[
            UpdateNotificationRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.ReadOnly
          ]
      object DeleteBudgetAction
          extends Effect[
            DeleteBudgetActionRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.ReadOnly
          ]
      object DeleteNotification
          extends Effect[
            DeleteNotificationRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.ReadOnly
          ]
      object DescribeBudgetActionsForBudget
          extends Stream[
            DescribeBudgetActionsForBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
          ]
      object UpdateBudget
          extends Effect[
            UpdateBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.ReadOnly
          ]
      object CreateBudgetAction
          extends Effect[
            CreateBudgetActionRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.ReadOnly
          ]
      object DescribeBudget
          extends Effect[
            DescribeBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly
          ]
      object DescribeBudgetPerformanceHistory
          extends Effect[
            DescribeBudgetPerformanceHistoryRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly
          ]
      object CreateNotification
          extends Effect[
            CreateNotificationRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.ReadOnly
          ]
      object UpdateSubscriber
          extends Effect[
            UpdateSubscriberRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.ReadOnly
          ]
      object ExecuteBudgetAction
          extends Effect[
            ExecuteBudgetActionRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.ReadOnly
          ]
      object DescribeBudgets
          extends Stream[
            DescribeBudgetsRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
          ]
      object DescribeBudgetActionsForAccount
          extends Stream[
            DescribeBudgetActionsForAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
          ]
      object CreateSubscriber
          extends Effect[
            CreateSubscriberRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.ReadOnly
          ]
      object UpdateBudgetAction
          extends Effect[
            UpdateBudgetActionRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly
          ]
      object DescribeNotificationsForBudget
          extends Stream[
            DescribeNotificationsForBudgetRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
          ]
      object DescribeBudgetActionHistories
          extends Stream[
            DescribeBudgetActionHistoriesRequest,
            AwsError,
            io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], Budgets] = ZLayer.fromServiceM { proxy =>
        withRuntime.map { rts =>
          new Budgets.Service {
            val api: BudgetsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: R1
            ): Budgets.Service = this
            def describeBudgetAction(request: DescribeBudgetActionRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly
            ] = proxy(DescribeBudgetAction, request)
            def deleteBudget(request: DeleteBudgetRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.ReadOnly
            ] = proxy(DeleteBudget, request)
            def createBudget(request: CreateBudgetRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.ReadOnly
            ] = proxy(CreateBudget, request)
            def deleteSubscriber(request: DeleteSubscriberRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.ReadOnly
            ] = proxy(DeleteSubscriber, request)
            def describeSubscribersForNotification(
                request: DescribeSubscribersForNotificationRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(DescribeSubscribersForNotification, request))
            def updateNotification(request: UpdateNotificationRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.ReadOnly
            ] = proxy(UpdateNotification, request)
            def deleteBudgetAction(request: DeleteBudgetActionRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.ReadOnly
            ] = proxy(DeleteBudgetAction, request)
            def deleteNotification(request: DeleteNotificationRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.ReadOnly
            ] = proxy(DeleteNotification, request)
            def describeBudgetActionsForBudget(
                request: DescribeBudgetActionsForBudgetRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeBudgetActionsForBudget, request))
            def updateBudget(request: UpdateBudgetRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.ReadOnly
            ] = proxy(UpdateBudget, request)
            def createBudgetAction(request: CreateBudgetActionRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.ReadOnly
            ] = proxy(CreateBudgetAction, request)
            def describeBudget(request: DescribeBudgetRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly
            ] = proxy(DescribeBudget, request)
            def describeBudgetPerformanceHistory(
                request: DescribeBudgetPerformanceHistoryRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly
            ] = proxy(DescribeBudgetPerformanceHistory, request)
            def createNotification(request: CreateNotificationRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.ReadOnly
            ] = proxy(CreateNotification, request)
            def updateSubscriber(request: UpdateSubscriberRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.ReadOnly
            ] = proxy(UpdateSubscriber, request)
            def executeBudgetAction(request: ExecuteBudgetActionRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.ReadOnly
            ] = proxy(ExecuteBudgetAction, request)
            def describeBudgets(request: DescribeBudgetsRequest): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeBudgets, request))
            def describeBudgetActionsForAccount(
                request: DescribeBudgetActionsForAccountRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeBudgetActionsForAccount, request))
            def createSubscriber(request: CreateSubscriberRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.ReadOnly
            ] = proxy(CreateSubscriber, request)
            def updateBudgetAction(request: UpdateBudgetActionRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly
            ] = proxy(UpdateBudgetAction, request)
            def describeNotificationsForBudget(
                request: DescribeNotificationsForBudgetRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeNotificationsForBudget, request))
            def describeBudgetActionHistories(
                request: DescribeBudgetActionHistoriesRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeBudgetActionHistories, request))
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Budgets] = customized(
    identity
  )
  def customized(
      customization: BudgetsAsyncClientBuilder => BudgetsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Budgets] = managed(
    customization
  ).toLayer
  def managed(
      customization: BudgetsAsyncClientBuilder => BudgetsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Budgets.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = BudgetsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[BudgetsAsyncClient, BudgetsAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[BudgetsAsyncClient, BudgetsAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  ) yield new BudgetsImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class BudgetsImpl[R](
      override val api: BudgetsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Budgets.Service
      with AwsServiceBase[R, BudgetsImpl] {
    override val serviceName: String = "Budgets"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): BudgetsImpl[R1] = new BudgetsImpl(api, newAspect, r)
    def describeBudgetAction(request: DescribeBudgetActionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest,
      DescribeBudgetActionResponse
    ]("describeBudgetAction", api.describeBudgetAction)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.wrap
      )
      .provide(r)
    def deleteBudget(request: DeleteBudgetRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest,
      DeleteBudgetResponse
    ]("deleteBudget", api.deleteBudget)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.wrap)
      .provide(r)
    def createBudget(request: CreateBudgetRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.CreateBudgetRequest,
      CreateBudgetResponse
    ]("createBudget", api.createBudget)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.wrap)
      .provide(r)
    def deleteSubscriber(request: DeleteSubscriberRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest,
      DeleteSubscriberResponse
    ]("deleteSubscriber", api.deleteSubscriber)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.wrap)
      .provide(r)
    def describeSubscribersForNotification(
        request: DescribeSubscribersForNotificationRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest,
      DescribeSubscribersForNotificationResponse,
      Subscriber
    ](
      "describeSubscribersForNotification",
      api.describeSubscribersForNotification,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.subscribers().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item))
      .provide(r)
    def updateNotification(request: UpdateNotificationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest,
      UpdateNotificationResponse
    ]("updateNotification", api.updateNotification)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.wrap)
      .provide(r)
    def deleteBudgetAction(request: DeleteBudgetActionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest,
      DeleteBudgetActionResponse
    ]("deleteBudgetAction", api.deleteBudgetAction)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.wrap)
      .provide(r)
    def deleteNotification(request: DeleteNotificationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest,
      DeleteNotificationResponse
    ]("deleteNotification", api.deleteNotification)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.wrap)
      .provide(r)
    def describeBudgetActionsForBudget(
        request: DescribeBudgetActionsForBudgetRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest,
      DescribeBudgetActionsForBudgetResponse,
      Action
    ](
      "describeBudgetActionsForBudget",
      api.describeBudgetActionsForBudget,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.actions().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.budgets.model.Action.wrap(item))
      .provide(r)
    def updateBudget(request: UpdateBudgetRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest,
      UpdateBudgetResponse
    ]("updateBudget", api.updateBudget)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.wrap)
      .provide(r)
    def createBudgetAction(request: CreateBudgetActionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.CreateBudgetActionRequest,
      CreateBudgetActionResponse
    ]("createBudgetAction", api.createBudgetAction)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.wrap)
      .provide(r)
    def describeBudget(request: DescribeBudgetRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest,
      DescribeBudgetResponse
    ]("describeBudget", api.describeBudget)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.wrap)
      .provide(r)
    def describeBudgetPerformanceHistory(
        request: DescribeBudgetPerformanceHistoryRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest,
      DescribeBudgetPerformanceHistoryResponse
    ]("describeBudgetPerformanceHistory", api.describeBudgetPerformanceHistory)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.wrap
    ).provide(r)
    def createNotification(request: CreateNotificationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.CreateNotificationRequest,
      CreateNotificationResponse
    ]("createNotification", api.createNotification)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.wrap)
      .provide(r)
    def updateSubscriber(request: UpdateSubscriberRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest,
      UpdateSubscriberResponse
    ]("updateSubscriber", api.updateSubscriber)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.wrap)
      .provide(r)
    def executeBudgetAction(request: ExecuteBudgetActionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest,
      ExecuteBudgetActionResponse
    ]("executeBudgetAction", api.executeBudgetAction)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.wrap
      )
      .provide(r)
    def describeBudgets(request: DescribeBudgetsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest,
      DescribeBudgetsResponse,
      Budget
    ](
      "describeBudgets",
      api.describeBudgets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.budgets().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.budgets.model.Budget.wrap(item))
      .provide(r)
    def describeBudgetActionsForAccount(
        request: DescribeBudgetActionsForAccountRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest,
      DescribeBudgetActionsForAccountResponse,
      Action
    ](
      "describeBudgetActionsForAccount",
      api.describeBudgetActionsForAccount,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.actions().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.budgets.model.Action.wrap(item))
      .provide(r)
    def createSubscriber(request: CreateSubscriberRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest,
      CreateSubscriberResponse
    ]("createSubscriber", api.createSubscriber)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.wrap)
      .provide(r)
    def updateBudgetAction(request: UpdateBudgetActionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest,
      UpdateBudgetActionResponse
    ]("updateBudgetAction", api.updateBudgetAction)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.wrap)
      .provide(r)
    def describeNotificationsForBudget(
        request: DescribeNotificationsForBudgetRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest,
      DescribeNotificationsForBudgetResponse,
      Notification
    ](
      "describeNotificationsForBudget",
      api.describeNotificationsForBudget,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.notifications().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.budgets.model.Notification.wrap(item))
      .provide(r)
    def describeBudgetActionHistories(
        request: DescribeBudgetActionHistoriesRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest,
      DescribeBudgetActionHistoriesResponse,
      ActionHistory
    ](
      "describeBudgetActionHistories",
      api.describeBudgetActionHistories,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.actionHistories().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.budgets.model.ActionHistory.wrap(item)
      )
      .provide(r)
  }
  def describeBudgetAction(request: DescribeBudgetActionRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeBudgetAction(request))
  def deleteBudget(request: DeleteBudgetRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DeleteBudgetResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteBudget(request))
  def createBudget(request: CreateBudgetRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.CreateBudgetResponse.ReadOnly
  ] = ZIO.accessM(_.get.createBudget(request))
  def deleteSubscriber(request: DeleteSubscriberRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DeleteSubscriberResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteSubscriber(request))
  def describeSubscribersForNotification(
      request: DescribeSubscribersForNotificationRequest
  ): ZStream[Budgets, AwsError, ReadOnly] =
    ZStream.accessStream(_.get.describeSubscribersForNotification(request))
  def updateNotification(request: UpdateNotificationRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.UpdateNotificationResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateNotification(request))
  def deleteBudgetAction(request: DeleteBudgetActionRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DeleteBudgetActionResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteBudgetAction(request))
  def deleteNotification(request: DeleteNotificationRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DeleteNotificationResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteNotification(request))
  def describeBudgetActionsForBudget(
      request: DescribeBudgetActionsForBudgetRequest
  ): ZStream[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
  ] = ZStream.accessStream(_.get.describeBudgetActionsForBudget(request))
  def updateBudget(request: UpdateBudgetRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.UpdateBudgetResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateBudget(request))
  def createBudgetAction(request: CreateBudgetActionRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.CreateBudgetActionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createBudgetAction(request))
  def describeBudget(request: DescribeBudgetRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeBudget(request))
  def describeBudgetPerformanceHistory(
      request: DescribeBudgetPerformanceHistoryRequest
  ): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetPerformanceHistoryResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeBudgetPerformanceHistory(request))
  def createNotification(request: CreateNotificationRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.CreateNotificationResponse.ReadOnly
  ] = ZIO.accessM(_.get.createNotification(request))
  def updateSubscriber(request: UpdateSubscriberRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.UpdateSubscriberResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateSubscriber(request))
  def executeBudgetAction(request: ExecuteBudgetActionRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.ExecuteBudgetActionResponse.ReadOnly
  ] = ZIO.accessM(_.get.executeBudgetAction(request))
  def describeBudgets(request: DescribeBudgetsRequest): ZStream[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.Budget.ReadOnly
  ] = ZStream.accessStream(_.get.describeBudgets(request))
  def describeBudgetActionsForAccount(
      request: DescribeBudgetActionsForAccountRequest
  ): ZStream[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.Action.ReadOnly
  ] = ZStream.accessStream(_.get.describeBudgetActionsForAccount(request))
  def createSubscriber(request: CreateSubscriberRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.CreateSubscriberResponse.ReadOnly
  ] = ZIO.accessM(_.get.createSubscriber(request))
  def updateBudgetAction(request: UpdateBudgetActionRequest): ZIO[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.UpdateBudgetActionResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateBudgetAction(request))
  def describeNotificationsForBudget(
      request: DescribeNotificationsForBudgetRequest
  ): ZStream[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.Notification.ReadOnly
  ] = ZStream.accessStream(_.get.describeNotificationsForBudget(request))
  def describeBudgetActionHistories(
      request: DescribeBudgetActionHistoriesRequest
  ): ZStream[
    Budgets,
    AwsError,
    io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
  ] = ZStream.accessStream(_.get.describeBudgetActionHistories(request))
}
