package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericTimestamp
import scala.jdk.CollectionConverters.*
final case class TimePeriod(
    start: Option[GenericTimestamp] = None,
    end: Option[GenericTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.TimePeriod = {
    import TimePeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.TimePeriod
      .builder()
      .optionallyWith(start.map(value => value: Instant))(_.start)
      .optionallyWith(end.map(value => value: Instant))(_.end)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.TimePeriod.wrap(buildAwsValue())
}
object TimePeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.TimePeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.TimePeriod =
      io.github.vigoo.zioaws.budgets.model.TimePeriod(
        startValue.map(value => value),
        endValue.map(value => value)
      )
    def startValue: Option[GenericTimestamp]
    def endValue: Option[GenericTimestamp]
    def start: ZIO[Any, AwsError, GenericTimestamp] =
      AwsError.unwrapOptionField("start", startValue)
    def end: ZIO[Any, AwsError, GenericTimestamp] =
      AwsError.unwrapOptionField("end", endValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.TimePeriod
  ) extends io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly {
    override def startValue: Option[GenericTimestamp] =
      scala.Option(impl.start()).map(value => value: GenericTimestamp)
    override def endValue: Option[GenericTimestamp] =
      scala.Option(impl.end()).map(value => value: GenericTimestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.TimePeriod
  ): io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly = new Wrapper(
    impl
  )
}
