package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeSubscribersForNotificationResponse(
    subscribers: Option[
      Iterable[io.github.vigoo.zioaws.budgets.model.Subscriber]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse = {
    import DescribeSubscribersForNotificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse
      .builder()
      .optionallyWith(
        subscribers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeSubscribersForNotificationResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeSubscribersForNotificationResponse
      .wrap(buildAwsValue())
}
object DescribeSubscribersForNotificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeSubscribersForNotificationResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeSubscribersForNotificationResponse(
          subscribersValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def subscribersValue
        : Option[List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]]
    def nextTokenValue: Option[GenericString]
    def subscribers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribers", subscribersValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeSubscribersForNotificationResponse.ReadOnly {
    override def subscribersValue: Option[
      List[io.github.vigoo.zioaws.budgets.model.Subscriber.ReadOnly]
    ] = scala
      .Option(impl.subscribers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.budgets.model.Subscriber.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeSubscribersForNotificationResponse.ReadOnly =
    new Wrapper(impl)
}
