package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class DescribeBudgetActionHistoriesResponse(
    actionHistories: Iterable[
      io.github.vigoo.zioaws.budgets.model.ActionHistory
    ],
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse = {
    import DescribeBudgetActionHistoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse
      .builder()
      .actionHistories(actionHistories.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesResponse.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesResponse
      .wrap(buildAwsValue())
}
object DescribeBudgetActionHistoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesResponse =
      io.github.vigoo.zioaws.budgets.model
        .DescribeBudgetActionHistoriesResponse(
          actionHistoriesValue.map { item =>
            item.editable
          },
          nextTokenValue.map(value => value)
        )
    def actionHistoriesValue
        : List[io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly]
    def nextTokenValue: Option[GenericString]
    def actionHistories: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly
    ]] = ZIO.succeed(actionHistoriesValue)
    def nextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse
  ) extends io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesResponse.ReadOnly {
    override def actionHistoriesValue
        : List[io.github.vigoo.zioaws.budgets.model.ActionHistory.ReadOnly] =
      impl
        .actionHistories()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.budgets.model.ActionHistory.wrap(item)
        }
        .toList
    override def nextTokenValue: Option[GenericString] =
      scala.Option(impl.nextToken()).map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse
  ): io.github.vigoo.zioaws.budgets.model.DescribeBudgetActionHistoriesResponse.ReadOnly =
    new Wrapper(impl)
}
