package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CalculatedSpend(
    actualSpend: io.github.vigoo.zioaws.budgets.model.Spend,
    forecastedSpend: Option[io.github.vigoo.zioaws.budgets.model.Spend] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.CalculatedSpend = {
    import CalculatedSpend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CalculatedSpend
      .builder()
      .actualSpend(actualSpend.buildAwsValue())
      .optionallyWith(forecastedSpend.map(value => value.buildAwsValue()))(
        _.forecastedSpend
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.CalculatedSpend.wrap(buildAwsValue())
}
object CalculatedSpend {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.CalculatedSpend
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.budgets.model.CalculatedSpend =
      io.github.vigoo.zioaws.budgets.model.CalculatedSpend(
        actualSpendValue.editable,
        forecastedSpendValue.map(value => value.editable)
      )
    def actualSpendValue: io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    def forecastedSpendValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    def actualSpend: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ] = ZIO.succeed(actualSpendValue)
    def forecastedSpend: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ] = AwsError.unwrapOptionField("forecastedSpend", forecastedSpendValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.CalculatedSpend
  ) extends io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly {
    override def actualSpendValue
        : io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly =
      io.github.vigoo.zioaws.budgets.model.Spend.wrap(impl.actualSpend())
    override def forecastedSpendValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly] = scala
      .Option(impl.forecastedSpend())
      .map(value => io.github.vigoo.zioaws.budgets.model.Spend.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.CalculatedSpend
  ): io.github.vigoo.zioaws.budgets.model.CalculatedSpend.ReadOnly =
    new Wrapper(impl)
}
