package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BudgetedAndActualAmounts(
    budgetedAmount: Option[io.github.vigoo.zioaws.budgets.model.Spend] = None,
    actualAmount: Option[io.github.vigoo.zioaws.budgets.model.Spend] = None,
    timePeriod: Option[io.github.vigoo.zioaws.budgets.model.TimePeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts = {
    import BudgetedAndActualAmounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts
      .builder()
      .optionallyWith(budgetedAmount.map(value => value.buildAwsValue()))(
        _.budgetedAmount
      )
      .optionallyWith(actualAmount.map(value => value.buildAwsValue()))(
        _.actualAmount
      )
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts
      .wrap(buildAwsValue())
}
object BudgetedAndActualAmounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts =
      io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts(
        budgetedAmountValue.map(value => value.editable),
        actualAmountValue.map(value => value.editable),
        timePeriodValue.map(value => value.editable)
      )
    def budgetedAmountValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    def actualAmountValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly]
    def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly]
    def budgetedAmount: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ] = AwsError.unwrapOptionField("budgetedAmount", budgetedAmountValue)
    def actualAmount: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly
    ] = AwsError.unwrapOptionField("actualAmount", actualAmountValue)
    def timePeriod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly
    ] = AwsError.unwrapOptionField("timePeriod", timePeriodValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts
  ) extends io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly {
    override def budgetedAmountValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly] = scala
      .Option(impl.budgetedAmount())
      .map(value => io.github.vigoo.zioaws.budgets.model.Spend.wrap(value))
    override def actualAmountValue
        : Option[io.github.vigoo.zioaws.budgets.model.Spend.ReadOnly] = scala
      .Option(impl.actualAmount())
      .map(value => io.github.vigoo.zioaws.budgets.model.Spend.wrap(value))
    override def timePeriodValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimePeriod.ReadOnly] =
      scala
        .Option(impl.timePeriod())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.TimePeriod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts
  ): io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly =
    new Wrapper(impl)
}
