package io.github.vigoo.zioaws.budgets.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.budgets.model.primitives.{
  GenericString,
  BudgetName
}
import scala.jdk.CollectionConverters.*
final case class BudgetPerformanceHistory(
    budgetName: Option[BudgetName] = None,
    budgetType: Option[io.github.vigoo.zioaws.budgets.model.BudgetType] = None,
    costFilters: Option[Map[GenericString, Iterable[GenericString]]] = None,
    costTypes: Option[io.github.vigoo.zioaws.budgets.model.CostTypes] = None,
    timeUnit: Option[io.github.vigoo.zioaws.budgets.model.TimeUnit] = None,
    budgetedAndActualAmountsList: Option[
      Iterable[io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory = {
    import BudgetPerformanceHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory
      .builder()
      .optionallyWith(budgetName.map(value => value: java.lang.String))(
        _.budgetName
      )
      .optionallyWith(budgetType.map(value => value.unwrap))(_.budgetType)
      .optionallyWith(
        costFilters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.costFilters)
      .optionallyWith(costTypes.map(value => value.buildAwsValue()))(
        _.costTypes
      )
      .optionallyWith(timeUnit.map(value => value.unwrap))(_.timeUnit)
      .optionallyWith(
        budgetedAndActualAmountsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgetedAndActualAmountsList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly =
    io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory
      .wrap(buildAwsValue())
}
object BudgetPerformanceHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory =
      io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory(
        budgetNameValue.map(value => value),
        budgetTypeValue.map(value => value),
        costFiltersValue.map(value => value),
        costTypesValue.map(value => value.editable),
        timeUnitValue.map(value => value),
        budgetedAndActualAmountsListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def budgetNameValue: Option[BudgetName]
    def budgetTypeValue: Option[io.github.vigoo.zioaws.budgets.model.BudgetType]
    def costFiltersValue: Option[Map[GenericString, List[GenericString]]]
    def costTypesValue
        : Option[io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly]
    def timeUnitValue: Option[io.github.vigoo.zioaws.budgets.model.TimeUnit]
    def budgetedAndActualAmountsListValue: Option[List[
      io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly
    ]]
    def budgetName: ZIO[Any, AwsError, BudgetName] =
      AwsError.unwrapOptionField("budgetName", budgetNameValue)
    def budgetType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.budgets.model.BudgetType] =
      AwsError.unwrapOptionField("budgetType", budgetTypeValue)
    def costFilters
        : ZIO[Any, AwsError, Map[GenericString, List[GenericString]]] =
      AwsError.unwrapOptionField("costFilters", costFiltersValue)
    def costTypes: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly
    ] = AwsError.unwrapOptionField("costTypes", costTypesValue)
    def timeUnit
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.budgets.model.TimeUnit] =
      AwsError.unwrapOptionField("timeUnit", timeUnitValue)
    def budgetedAndActualAmountsList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "budgetedAndActualAmountsList",
      budgetedAndActualAmountsListValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory
  ) extends io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly {
    override def budgetNameValue: Option[BudgetName] =
      scala.Option(impl.budgetName()).map(value => value: BudgetName)
    override def budgetTypeValue
        : Option[io.github.vigoo.zioaws.budgets.model.BudgetType] = scala
      .Option(impl.budgetType())
      .map(value => io.github.vigoo.zioaws.budgets.model.BudgetType.wrap(value))
    override def costFiltersValue
        : Option[Map[GenericString, List[GenericString]]] = scala
      .Option(impl.costFilters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: GenericString) -> value.asScala.map { item =>
              item: GenericString
            }.toList
          })
          .toMap
      )
    override def costTypesValue
        : Option[io.github.vigoo.zioaws.budgets.model.CostTypes.ReadOnly] =
      scala
        .Option(impl.costTypes())
        .map(value =>
          io.github.vigoo.zioaws.budgets.model.CostTypes.wrap(value)
        )
    override def timeUnitValue
        : Option[io.github.vigoo.zioaws.budgets.model.TimeUnit] = scala
      .Option(impl.timeUnit())
      .map(value => io.github.vigoo.zioaws.budgets.model.TimeUnit.wrap(value))
    override def budgetedAndActualAmountsListValue: Option[List[
      io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts.ReadOnly
    ]] = scala
      .Option(impl.budgetedAndActualAmountsList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.budgets.model.BudgetedAndActualAmounts
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory
  ): io.github.vigoo.zioaws.budgets.model.BudgetPerformanceHistory.ReadOnly =
    new Wrapper(impl)
}
