package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBudgetRequest(accountId: primitives.AccountId, newBudget: Budget) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest = {
    import UpdateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest.builder().accountId(accountId: java.lang.String).newBudget(newBudget.buildAwsValue()).build()
  }
  def asReadOnly: UpdateBudgetRequest.ReadOnly = UpdateBudgetRequest.wrap(buildAwsValue())
}
object UpdateBudgetRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBudgetRequest = UpdateBudgetRequest(accountIdValue, newBudgetValue.editable)
    def accountIdValue: primitives.AccountId
    def newBudgetValue: Budget.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def newBudget: ZIO[Any, Nothing, Budget.ReadOnly] = ZIO.succeed(newBudgetValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest) extends UpdateBudgetRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def newBudgetValue: Budget.ReadOnly = Budget.wrap(impl.newBudget())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest): ReadOnly = new Wrapper(impl)
}