package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait SubscriptionType { def unwrap: software.amazon.awssdk.services.budgets.model.SubscriptionType }
object SubscriptionType {
  def wrap(value: software.amazon.awssdk.services.budgets.model.SubscriptionType): SubscriptionType = value match {
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.SNS =>
      val r = SNS
      r
    case software.amazon.awssdk.services.budgets.model.SubscriptionType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion extends SubscriptionType { override def unwrap: software.amazon.awssdk.services.budgets.model.SubscriptionType = software.amazon.awssdk.services.budgets.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION }
  case object SNS extends SubscriptionType { override def unwrap: software.amazon.awssdk.services.budgets.model.SubscriptionType = software.amazon.awssdk.services.budgets.model.SubscriptionType.SNS }
  case object EMAIL extends SubscriptionType { override def unwrap: software.amazon.awssdk.services.budgets.model.SubscriptionType = software.amazon.awssdk.services.budgets.model.SubscriptionType.EMAIL }
}