package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionHistoriesResponse(actionHistories: Iterable[ActionHistory], nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse = {
    import DescribeBudgetActionHistoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse.builder().actionHistories(actionHistories.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetActionHistoriesResponse.ReadOnly = DescribeBudgetActionHistoriesResponse.wrap(buildAwsValue())
}
object DescribeBudgetActionHistoriesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionHistoriesResponse = DescribeBudgetActionHistoriesResponse(actionHistoriesValue.map { item => 
      item.editable
    }, nextTokenValue.map(value => value))
    def actionHistoriesValue: List[ActionHistory.ReadOnly]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def actionHistories: ZIO[Any, Nothing, List[ActionHistory.ReadOnly]] = ZIO.succeed(actionHistoriesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse) extends DescribeBudgetActionHistoriesResponse.ReadOnly {
    override def actionHistoriesValue: List[ActionHistory.ReadOnly] = impl.actionHistories().asScala.map { item => 
      ActionHistory.wrap(item)
    }.toList
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse): ReadOnly = new Wrapper(impl)
}