package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Action(actionId: primitives.ActionId, budgetName: primitives.BudgetName, notificationType: NotificationType, actionType: ActionType, actionThreshold: ActionThreshold, definition: Definition, executionRoleArn: primitives.RoleArn, approvalModel: ApprovalModel, status: ActionStatus, subscribers: Iterable[Subscriber]) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Action.builder().actionId(actionId: java.lang.String).budgetName(budgetName: java.lang.String).notificationType(notificationType.unwrap).actionType(actionType.unwrap).actionThreshold(actionThreshold.buildAwsValue()).definition(definition.buildAwsValue()).executionRoleArn(executionRoleArn: java.lang.String).approvalModel(approvalModel.unwrap).status(status.unwrap).subscribers(subscribers.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: Action.ReadOnly = Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Action] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Action = Action(actionIdValue, budgetNameValue, notificationTypeValue, actionTypeValue, actionThresholdValue.editable, definitionValue.editable, executionRoleArnValue, approvalModelValue, statusValue, subscribersValue.map { item => 
      item.editable
    })
    def actionIdValue: primitives.ActionId
    def budgetNameValue: primitives.BudgetName
    def notificationTypeValue: NotificationType
    def actionTypeValue: ActionType
    def actionThresholdValue: ActionThreshold.ReadOnly
    def definitionValue: Definition.ReadOnly
    def executionRoleArnValue: primitives.RoleArn
    def approvalModelValue: ApprovalModel
    def statusValue: ActionStatus
    def subscribersValue: List[Subscriber.ReadOnly]
    def actionId: ZIO[Any, Nothing, primitives.ActionId] = ZIO.succeed(actionIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def notificationType: ZIO[Any, Nothing, NotificationType] = ZIO.succeed(notificationTypeValue)
    def actionType: ZIO[Any, Nothing, ActionType] = ZIO.succeed(actionTypeValue)
    def actionThreshold: ZIO[Any, Nothing, ActionThreshold.ReadOnly] = ZIO.succeed(actionThresholdValue)
    def definition: ZIO[Any, Nothing, Definition.ReadOnly] = ZIO.succeed(definitionValue)
    def executionRoleArn: ZIO[Any, Nothing, primitives.RoleArn] = ZIO.succeed(executionRoleArnValue)
    def approvalModel: ZIO[Any, Nothing, ApprovalModel] = ZIO.succeed(approvalModelValue)
    def status: ZIO[Any, Nothing, ActionStatus] = ZIO.succeed(statusValue)
    def subscribers: ZIO[Any, Nothing, List[Subscriber.ReadOnly]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Action) extends Action.ReadOnly {
    override def actionIdValue: primitives.ActionId = impl.actionId(): primitives.ActionId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def notificationTypeValue: NotificationType = NotificationType.wrap(impl.notificationType())
    override def actionTypeValue: ActionType = ActionType.wrap(impl.actionType())
    override def actionThresholdValue: ActionThreshold.ReadOnly = ActionThreshold.wrap(impl.actionThreshold())
    override def definitionValue: Definition.ReadOnly = Definition.wrap(impl.definition())
    override def executionRoleArnValue: primitives.RoleArn = impl.executionRoleArn(): primitives.RoleArn
    override def approvalModelValue: ApprovalModel = ApprovalModel.wrap(impl.approvalModel())
    override def statusValue: ActionStatus = ActionStatus.wrap(impl.status())
    override def subscribersValue: List[Subscriber.ReadOnly] = impl.subscribers().asScala.map { item => 
      Subscriber.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Action): ReadOnly = new Wrapper(impl)
}