package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TimePeriod(start: scala.Option[primitives.GenericTimestamp] = None, end: scala.Option[primitives.GenericTimestamp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.TimePeriod = {
    import TimePeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.TimePeriod.builder().optionallyWith(start.map(value => value: java.time.Instant))(_.start).optionallyWith(end.map(value => value: java.time.Instant))(_.end).build()
  }
  def asReadOnly: TimePeriod.ReadOnly = TimePeriod.wrap(buildAwsValue())
}
object TimePeriod {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.TimePeriod] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TimePeriod = TimePeriod(startValue.map(value => value), endValue.map(value => value))
    def startValue: scala.Option[primitives.GenericTimestamp]
    def endValue: scala.Option[primitives.GenericTimestamp]
    def start: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericTimestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("start", startValue)
    def end: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericTimestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("end", endValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.TimePeriod) extends TimePeriod.ReadOnly {
    override def startValue: scala.Option[primitives.GenericTimestamp] = scala.Option(impl.start()).map(value => value: primitives.GenericTimestamp)
    override def endValue: scala.Option[primitives.GenericTimestamp] = scala.Option(impl.end()).map(value => value: primitives.GenericTimestamp)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.TimePeriod): ReadOnly = new Wrapper(impl)
}