package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ScpActionDefinition(policyId: primitives.PolicyId, targetIds: Iterable[primitives.TargetId]) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.ScpActionDefinition = {
    import ScpActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ScpActionDefinition.builder().policyId(policyId: java.lang.String).targetIds(targetIds.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: ScpActionDefinition.ReadOnly = ScpActionDefinition.wrap(buildAwsValue())
}
object ScpActionDefinition {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.ScpActionDefinition] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ScpActionDefinition = ScpActionDefinition(policyIdValue, targetIdsValue)
    def policyIdValue: primitives.PolicyId
    def targetIdsValue: List[primitives.TargetId]
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
    def targetIds: ZIO[Any, Nothing, List[primitives.TargetId]] = ZIO.succeed(targetIdsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.ScpActionDefinition) extends ScpActionDefinition.ReadOnly {
    override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId
    override def targetIdsValue: List[primitives.TargetId] = impl.targetIds().asScala.map { item => 
      item: primitives.TargetId
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.ScpActionDefinition): ReadOnly = new Wrapper(impl)
}