package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetPerformanceHistoryResponse(budgetPerformanceHistory: scala.Option[BudgetPerformanceHistory] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse = {
    import DescribeBudgetPerformanceHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse.builder().optionallyWith(budgetPerformanceHistory.map(value => value.buildAwsValue()))(_.budgetPerformanceHistory).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetPerformanceHistoryResponse.ReadOnly = DescribeBudgetPerformanceHistoryResponse.wrap(buildAwsValue())
}
object DescribeBudgetPerformanceHistoryResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetPerformanceHistoryResponse = DescribeBudgetPerformanceHistoryResponse(budgetPerformanceHistoryValue.map(value => value.editable), nextTokenValue.map(value => value))
    def budgetPerformanceHistoryValue: scala.Option[BudgetPerformanceHistory.ReadOnly]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def budgetPerformanceHistory: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BudgetPerformanceHistory.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetPerformanceHistory", budgetPerformanceHistoryValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse) extends DescribeBudgetPerformanceHistoryResponse.ReadOnly {
    override def budgetPerformanceHistoryValue: scala.Option[BudgetPerformanceHistory.ReadOnly] = scala.Option(impl.budgetPerformanceHistory()).map(value => BudgetPerformanceHistory.wrap(value))
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse): ReadOnly = new Wrapper(impl)
}