package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteBudgetActionResponse(accountId: primitives.AccountId, budgetName: primitives.BudgetName, action: Action) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse = {
    import DeleteBudgetActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).action(action.buildAwsValue()).build()
  }
  def asReadOnly: DeleteBudgetActionResponse.ReadOnly = DeleteBudgetActionResponse.wrap(buildAwsValue())
}
object DeleteBudgetActionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteBudgetActionResponse = DeleteBudgetActionResponse(accountIdValue, budgetNameValue, actionValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionValue: Action.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def action: ZIO[Any, Nothing, Action.ReadOnly] = ZIO.succeed(actionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse) extends DeleteBudgetActionResponse.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionValue: Action.ReadOnly = Action.wrap(impl.action())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse): ReadOnly = new Wrapper(impl)
}