package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class BudgetedAndActualAmounts(budgetedAmount: scala.Option[Spend] = None, actualAmount: scala.Option[Spend] = None, timePeriod: scala.Option[TimePeriod] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts = {
    import BudgetedAndActualAmounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts.builder().optionallyWith(budgetedAmount.map(value => value.buildAwsValue()))(_.budgetedAmount).optionallyWith(actualAmount.map(value => value.buildAwsValue()))(_.actualAmount).optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).build()
  }
  def asReadOnly: BudgetedAndActualAmounts.ReadOnly = BudgetedAndActualAmounts.wrap(buildAwsValue())
}
object BudgetedAndActualAmounts {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: BudgetedAndActualAmounts = BudgetedAndActualAmounts(budgetedAmountValue.map(value => value.editable), actualAmountValue.map(value => value.editable), timePeriodValue.map(value => value.editable))
    def budgetedAmountValue: scala.Option[Spend.ReadOnly]
    def actualAmountValue: scala.Option[Spend.ReadOnly]
    def timePeriodValue: scala.Option[TimePeriod.ReadOnly]
    def budgetedAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Spend.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetedAmount", budgetedAmountValue)
    def actualAmount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Spend.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("actualAmount", actualAmountValue)
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TimePeriod.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts) extends BudgetedAndActualAmounts.ReadOnly {
    override def budgetedAmountValue: scala.Option[Spend.ReadOnly] = scala.Option(impl.budgetedAmount()).map(value => Spend.wrap(value))
    override def actualAmountValue: scala.Option[Spend.ReadOnly] = scala.Option(impl.actualAmount()).map(value => Spend.wrap(value))
    override def timePeriodValue: scala.Option[TimePeriod.ReadOnly] = scala.Option(impl.timePeriod()).map(value => TimePeriod.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts): ReadOnly = new Wrapper(impl)
}