package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait BudgetType { def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType }
object BudgetType {
  def wrap(value: software.amazon.awssdk.services.budgets.model.BudgetType): BudgetType = value match {
    case software.amazon.awssdk.services.budgets.model.BudgetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.USAGE =>
      val r = USAGE
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.COST =>
      val r = COST
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.RI_UTILIZATION =>
      val r = RI_UTILIZATION
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.RI_COVERAGE =>
      val r = RI_COVERAGE
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.SAVINGS_PLANS_UTILIZATION =>
      val r = SAVINGS_PLANS_UTILIZATION
      r
    case software.amazon.awssdk.services.budgets.model.BudgetType.SAVINGS_PLANS_COVERAGE =>
      val r = SAVINGS_PLANS_COVERAGE
      r
  }
  case object unknownToSdkVersion extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.UNKNOWN_TO_SDK_VERSION }
  case object USAGE extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.USAGE }
  case object COST extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.COST }
  case object RI_UTILIZATION extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.RI_UTILIZATION }
  case object RI_COVERAGE extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.RI_COVERAGE }
  case object SAVINGS_PLANS_UTILIZATION extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.SAVINGS_PLANS_UTILIZATION }
  case object SAVINGS_PLANS_COVERAGE extends BudgetType { override def unwrap: software.amazon.awssdk.services.budgets.model.BudgetType = software.amazon.awssdk.services.budgets.model.BudgetType.SAVINGS_PLANS_COVERAGE }
}