package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateNotificationRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, oldNotification: Notification, newNotification: Notification) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest = {
    import UpdateNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).oldNotification(oldNotification.buildAwsValue()).newNotification(newNotification.buildAwsValue()).build()
  }
  def asReadOnly: UpdateNotificationRequest.ReadOnly = UpdateNotificationRequest.wrap(buildAwsValue())
}
object UpdateNotificationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateNotificationRequest = UpdateNotificationRequest(accountIdValue, budgetNameValue, oldNotificationValue.editable, newNotificationValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def oldNotificationValue: Notification.ReadOnly
    def newNotificationValue: Notification.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def oldNotification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(oldNotificationValue)
    def newNotification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(newNotificationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest) extends UpdateNotificationRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def oldNotificationValue: Notification.ReadOnly = Notification.wrap(impl.oldNotification())
    override def newNotificationValue: Notification.ReadOnly = Notification.wrap(impl.newNotification())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest): ReadOnly = new Wrapper(impl)
}