package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExecuteBudgetActionRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, actionId: primitives.ActionId, executionType: ExecutionType) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest = {
    import ExecuteBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).actionId(actionId: java.lang.String).executionType(executionType.unwrap).build()
  }
  def asReadOnly: ExecuteBudgetActionRequest.ReadOnly = ExecuteBudgetActionRequest.wrap(buildAwsValue())
}
object ExecuteBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExecuteBudgetActionRequest = ExecuteBudgetActionRequest(accountIdValue, budgetNameValue, actionIdValue, executionTypeValue)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionIdValue: primitives.ActionId
    def executionTypeValue: ExecutionType
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, primitives.ActionId] = ZIO.succeed(actionIdValue)
    def executionType: ZIO[Any, Nothing, ExecutionType] = ZIO.succeed(executionTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest) extends ExecuteBudgetActionRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionIdValue: primitives.ActionId = impl.actionId(): primitives.ActionId
    override def executionTypeValue: ExecutionType = ExecutionType.wrap(impl.executionType())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest): ReadOnly = new Wrapper(impl)
}