package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeNotificationsForBudgetResponse(notifications: scala.Option[Iterable[Notification]] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse = {
    import DescribeNotificationsForBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse.builder().optionallyWith(notifications.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.notifications).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeNotificationsForBudgetResponse.ReadOnly = DescribeNotificationsForBudgetResponse.wrap(buildAwsValue())
}
object DescribeNotificationsForBudgetResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeNotificationsForBudgetResponse = DescribeNotificationsForBudgetResponse(notificationsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def notificationsValue: scala.Option[List[Notification.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def notifications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Notification.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notifications", notificationsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse) extends DescribeNotificationsForBudgetResponse.ReadOnly {
    override def notificationsValue: scala.Option[List[Notification.ReadOnly]] = scala.Option(impl.notifications()).map(value => value.asScala.map { item => 
      Notification.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse): ReadOnly = new Wrapper(impl)
}