package io.github.vigoo.zioaws.budgets
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type AccountId = String
    type ActionId = String
    type BudgetName = String
    type GenericString = String
    type GenericTimestamp = Instant
    type Group = String
    type InstanceId = String
    type MaxResults = Int
    type NotificationThreshold = Double
    type NullableBoolean = Boolean
    type NumericValue = String
    type PolicyArn = String
    type PolicyId = String
    type Region = String
    type Role = String
    type RoleArn = String
    type SubscriberAddress = String
    type TargetId = String
    type UnitValue = String
    type User = String
  }
  type ActionHistories = List[ActionHistory]
  type Actions = List[Action]
  type BudgetedAndActualAmountsList = List[BudgetedAndActualAmounts]
  type Budgets = List[Budget]
  type CostFilters = Map[primitives.GenericString, Iterable[primitives.GenericString]]
  type DimensionValues = List[primitives.GenericString]
  type Groups = List[primitives.Group]
  type InstanceIds = List[primitives.InstanceId]
  type NotificationWithSubscribersList = List[NotificationWithSubscribers]
  type Notifications = List[Notification]
  type PlannedBudgetLimits = Map[primitives.GenericString, Spend]
  type Roles = List[primitives.Role]
  type Subscribers = List[Subscriber]
  type TargetIds = List[primitives.TargetId]
  type Users = List[primitives.User]
}