package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait EventType { def unwrap: software.amazon.awssdk.services.budgets.model.EventType }
object EventType {
  def wrap(value: software.amazon.awssdk.services.budgets.model.EventType): EventType = value match {
    case software.amazon.awssdk.services.budgets.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.EventType.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.budgets.model.EventType.CREATE_ACTION =>
      val r = CREATE_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.EventType.DELETE_ACTION =>
      val r = DELETE_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.EventType.UPDATE_ACTION =>
      val r = UPDATE_ACTION
      r
    case software.amazon.awssdk.services.budgets.model.EventType.EXECUTE_ACTION =>
      val r = EXECUTE_ACTION
      r
  }
  case object unknownToSdkVersion extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.UNKNOWN_TO_SDK_VERSION }
  case object SYSTEM extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.SYSTEM }
  case object CREATE_ACTION extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.CREATE_ACTION }
  case object DELETE_ACTION extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.DELETE_ACTION }
  case object UPDATE_ACTION extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.UPDATE_ACTION }
  case object EXECUTE_ACTION extends EventType { override def unwrap: software.amazon.awssdk.services.budgets.model.EventType = software.amazon.awssdk.services.budgets.model.EventType.EXECUTE_ACTION }
}