package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeSubscribersForNotificationResponse(subscribers: scala.Option[Iterable[Subscriber]] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse = {
    import DescribeSubscribersForNotificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse.builder().optionallyWith(subscribers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.subscribers).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeSubscribersForNotificationResponse.ReadOnly = DescribeSubscribersForNotificationResponse.wrap(buildAwsValue())
}
object DescribeSubscribersForNotificationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeSubscribersForNotificationResponse = DescribeSubscribersForNotificationResponse(subscribersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def subscribersValue: scala.Option[List[Subscriber.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def subscribers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Subscriber.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscribers", subscribersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse) extends DescribeSubscribersForNotificationResponse.ReadOnly {
    override def subscribersValue: scala.Option[List[Subscriber.ReadOnly]] = scala.Option(impl.subscribers()).map(value => value.asScala.map { item => 
      Subscriber.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse): ReadOnly = new Wrapper(impl)
}