package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteSubscriberRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, notification: Notification, subscriber: Subscriber) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest = {
    import DeleteSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).notification(notification.buildAwsValue()).subscriber(subscriber.buildAwsValue()).build()
  }
  def asReadOnly: DeleteSubscriberRequest.ReadOnly = DeleteSubscriberRequest.wrap(buildAwsValue())
}
object DeleteSubscriberRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteSubscriberRequest = DeleteSubscriberRequest(accountIdValue, budgetNameValue, notificationValue.editable, subscriberValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def notificationValue: Notification.ReadOnly
    def subscriberValue: Subscriber.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(notificationValue)
    def subscriber: ZIO[Any, Nothing, Subscriber.ReadOnly] = ZIO.succeed(subscriberValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest) extends DeleteSubscriberRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def notificationValue: Notification.ReadOnly = Notification.wrap(impl.notification())
    override def subscriberValue: Subscriber.ReadOnly = Subscriber.wrap(impl.subscriber())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest): ReadOnly = new Wrapper(impl)
}