package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.budgets.{ BudgetsAsyncClient, BudgetsAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object budgets {
  type Budgets = Has[Budgets.Service]
  object Budgets {
    trait Service extends AspectSupport[Service] {
      val api: BudgetsAsyncClient
      def describeBudgetAction(request: model.DescribeBudgetActionRequest): IO[AwsError, model.DescribeBudgetActionResponse.ReadOnly]
      def deleteBudget(request: model.DeleteBudgetRequest): IO[AwsError, model.DeleteBudgetResponse.ReadOnly]
      def createBudget(request: model.CreateBudgetRequest): IO[AwsError, model.CreateBudgetResponse.ReadOnly]
      def deleteSubscriber(request: model.DeleteSubscriberRequest): IO[AwsError, model.DeleteSubscriberResponse.ReadOnly]
      def describeSubscribersForNotification(request: model.DescribeSubscribersForNotificationRequest): ZStream[Any, AwsError, model.Subscriber.ReadOnly]
      def updateNotification(request: model.UpdateNotificationRequest): IO[AwsError, model.UpdateNotificationResponse.ReadOnly]
      def deleteBudgetAction(request: model.DeleteBudgetActionRequest): IO[AwsError, model.DeleteBudgetActionResponse.ReadOnly]
      def deleteNotification(request: model.DeleteNotificationRequest): IO[AwsError, model.DeleteNotificationResponse.ReadOnly]
      def describeBudgetActionsForBudget(request: model.DescribeBudgetActionsForBudgetRequest): ZStream[Any, AwsError, model.Action.ReadOnly]
      def updateBudget(request: model.UpdateBudgetRequest): IO[AwsError, model.UpdateBudgetResponse.ReadOnly]
      def createBudgetAction(request: model.CreateBudgetActionRequest): IO[AwsError, model.CreateBudgetActionResponse.ReadOnly]
      def describeBudget(request: model.DescribeBudgetRequest): IO[AwsError, model.DescribeBudgetResponse.ReadOnly]
      def describeBudgetPerformanceHistory(request: model.DescribeBudgetPerformanceHistoryRequest): IO[AwsError, model.DescribeBudgetPerformanceHistoryResponse.ReadOnly]
      def createNotification(request: model.CreateNotificationRequest): IO[AwsError, model.CreateNotificationResponse.ReadOnly]
      def updateSubscriber(request: model.UpdateSubscriberRequest): IO[AwsError, model.UpdateSubscriberResponse.ReadOnly]
      def executeBudgetAction(request: model.ExecuteBudgetActionRequest): IO[AwsError, model.ExecuteBudgetActionResponse.ReadOnly]
      def describeBudgets(request: model.DescribeBudgetsRequest): ZStream[Any, AwsError, model.Budget.ReadOnly]
      def describeBudgetActionsForAccount(request: model.DescribeBudgetActionsForAccountRequest): ZStream[Any, AwsError, model.Action.ReadOnly]
      def createSubscriber(request: model.CreateSubscriberRequest): IO[AwsError, model.CreateSubscriberResponse.ReadOnly]
      def updateBudgetAction(request: model.UpdateBudgetActionRequest): IO[AwsError, model.UpdateBudgetActionResponse.ReadOnly]
      def describeNotificationsForBudget(request: model.DescribeNotificationsForBudgetRequest): ZStream[Any, AwsError, model.Notification.ReadOnly]
      def describeBudgetActionHistories(request: model.DescribeBudgetActionHistoriesRequest): ZStream[Any, AwsError, model.ActionHistory.ReadOnly]
    }
    object BudgetsMock extends zio.test.mock.Mock[Budgets] {
      object DescribeBudgetAction extends Effect[model.DescribeBudgetActionRequest, AwsError, model.DescribeBudgetActionResponse.ReadOnly]
      object DeleteBudget extends Effect[model.DeleteBudgetRequest, AwsError, model.DeleteBudgetResponse.ReadOnly]
      object CreateBudget extends Effect[model.CreateBudgetRequest, AwsError, model.CreateBudgetResponse.ReadOnly]
      object DeleteSubscriber extends Effect[model.DeleteSubscriberRequest, AwsError, model.DeleteSubscriberResponse.ReadOnly]
      object DescribeSubscribersForNotification extends Stream[model.DescribeSubscribersForNotificationRequest, AwsError, model.Subscriber.ReadOnly]
      object UpdateNotification extends Effect[model.UpdateNotificationRequest, AwsError, model.UpdateNotificationResponse.ReadOnly]
      object DeleteBudgetAction extends Effect[model.DeleteBudgetActionRequest, AwsError, model.DeleteBudgetActionResponse.ReadOnly]
      object DeleteNotification extends Effect[model.DeleteNotificationRequest, AwsError, model.DeleteNotificationResponse.ReadOnly]
      object DescribeBudgetActionsForBudget extends Stream[model.DescribeBudgetActionsForBudgetRequest, AwsError, model.Action.ReadOnly]
      object UpdateBudget extends Effect[model.UpdateBudgetRequest, AwsError, model.UpdateBudgetResponse.ReadOnly]
      object CreateBudgetAction extends Effect[model.CreateBudgetActionRequest, AwsError, model.CreateBudgetActionResponse.ReadOnly]
      object DescribeBudget extends Effect[model.DescribeBudgetRequest, AwsError, model.DescribeBudgetResponse.ReadOnly]
      object DescribeBudgetPerformanceHistory extends Effect[model.DescribeBudgetPerformanceHistoryRequest, AwsError, model.DescribeBudgetPerformanceHistoryResponse.ReadOnly]
      object CreateNotification extends Effect[model.CreateNotificationRequest, AwsError, model.CreateNotificationResponse.ReadOnly]
      object UpdateSubscriber extends Effect[model.UpdateSubscriberRequest, AwsError, model.UpdateSubscriberResponse.ReadOnly]
      object ExecuteBudgetAction extends Effect[model.ExecuteBudgetActionRequest, AwsError, model.ExecuteBudgetActionResponse.ReadOnly]
      object DescribeBudgets extends Stream[model.DescribeBudgetsRequest, AwsError, model.Budget.ReadOnly]
      object DescribeBudgetActionsForAccount extends Stream[model.DescribeBudgetActionsForAccountRequest, AwsError, model.Action.ReadOnly]
      object CreateSubscriber extends Effect[model.CreateSubscriberRequest, AwsError, model.CreateSubscriberResponse.ReadOnly]
      object UpdateBudgetAction extends Effect[model.UpdateBudgetActionRequest, AwsError, model.UpdateBudgetActionResponse.ReadOnly]
      object DescribeNotificationsForBudget extends Stream[model.DescribeNotificationsForBudgetRequest, AwsError, model.Notification.ReadOnly]
      object DescribeBudgetActionHistories extends Stream[model.DescribeBudgetActionHistoriesRequest, AwsError, model.ActionHistory.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], Budgets] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new Budgets.Service {
            val api: BudgetsAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): Budgets.Service = this
            def describeBudgetAction(request: model.DescribeBudgetActionRequest): IO[AwsError, model.DescribeBudgetActionResponse.ReadOnly] = proxy(DescribeBudgetAction, request)
            def deleteBudget(request: model.DeleteBudgetRequest): IO[AwsError, model.DeleteBudgetResponse.ReadOnly] = proxy(DeleteBudget, request)
            def createBudget(request: model.CreateBudgetRequest): IO[AwsError, model.CreateBudgetResponse.ReadOnly] = proxy(CreateBudget, request)
            def deleteSubscriber(request: model.DeleteSubscriberRequest): IO[AwsError, model.DeleteSubscriberResponse.ReadOnly] = proxy(DeleteSubscriber, request)
            def describeSubscribersForNotification(request: model.DescribeSubscribersForNotificationRequest): ZStream[Any, AwsError, model.Subscriber.ReadOnly] = rts.unsafeRun(proxy(DescribeSubscribersForNotification, request))
            def updateNotification(request: model.UpdateNotificationRequest): IO[AwsError, model.UpdateNotificationResponse.ReadOnly] = proxy(UpdateNotification, request)
            def deleteBudgetAction(request: model.DeleteBudgetActionRequest): IO[AwsError, model.DeleteBudgetActionResponse.ReadOnly] = proxy(DeleteBudgetAction, request)
            def deleteNotification(request: model.DeleteNotificationRequest): IO[AwsError, model.DeleteNotificationResponse.ReadOnly] = proxy(DeleteNotification, request)
            def describeBudgetActionsForBudget(request: model.DescribeBudgetActionsForBudgetRequest): ZStream[Any, AwsError, model.Action.ReadOnly] = rts.unsafeRun(proxy(DescribeBudgetActionsForBudget, request))
            def updateBudget(request: model.UpdateBudgetRequest): IO[AwsError, model.UpdateBudgetResponse.ReadOnly] = proxy(UpdateBudget, request)
            def createBudgetAction(request: model.CreateBudgetActionRequest): IO[AwsError, model.CreateBudgetActionResponse.ReadOnly] = proxy(CreateBudgetAction, request)
            def describeBudget(request: model.DescribeBudgetRequest): IO[AwsError, model.DescribeBudgetResponse.ReadOnly] = proxy(DescribeBudget, request)
            def describeBudgetPerformanceHistory(request: model.DescribeBudgetPerformanceHistoryRequest): IO[AwsError, model.DescribeBudgetPerformanceHistoryResponse.ReadOnly] = proxy(DescribeBudgetPerformanceHistory, request)
            def createNotification(request: model.CreateNotificationRequest): IO[AwsError, model.CreateNotificationResponse.ReadOnly] = proxy(CreateNotification, request)
            def updateSubscriber(request: model.UpdateSubscriberRequest): IO[AwsError, model.UpdateSubscriberResponse.ReadOnly] = proxy(UpdateSubscriber, request)
            def executeBudgetAction(request: model.ExecuteBudgetActionRequest): IO[AwsError, model.ExecuteBudgetActionResponse.ReadOnly] = proxy(ExecuteBudgetAction, request)
            def describeBudgets(request: model.DescribeBudgetsRequest): ZStream[Any, AwsError, model.Budget.ReadOnly] = rts.unsafeRun(proxy(DescribeBudgets, request))
            def describeBudgetActionsForAccount(request: model.DescribeBudgetActionsForAccountRequest): ZStream[Any, AwsError, model.Action.ReadOnly] = rts.unsafeRun(proxy(DescribeBudgetActionsForAccount, request))
            def createSubscriber(request: model.CreateSubscriberRequest): IO[AwsError, model.CreateSubscriberResponse.ReadOnly] = proxy(CreateSubscriber, request)
            def updateBudgetAction(request: model.UpdateBudgetActionRequest): IO[AwsError, model.UpdateBudgetActionResponse.ReadOnly] = proxy(UpdateBudgetAction, request)
            def describeNotificationsForBudget(request: model.DescribeNotificationsForBudgetRequest): ZStream[Any, AwsError, model.Notification.ReadOnly] = rts.unsafeRun(proxy(DescribeNotificationsForBudget, request))
            def describeBudgetActionHistories(request: model.DescribeBudgetActionHistoriesRequest): ZStream[Any, AwsError, model.ActionHistory.ReadOnly] = rts.unsafeRun(proxy(DescribeBudgetActionHistories, request))
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Budgets] = customized(identity)
  def customized(customization: BudgetsAsyncClientBuilder => BudgetsAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Budgets] = managed(customization).toLayer
  def managed(customization: BudgetsAsyncClientBuilder => BudgetsAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Budgets.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = BudgetsAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[BudgetsAsyncClient, BudgetsAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[BudgetsAsyncClient, BudgetsAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new BudgetsImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class BudgetsImpl[R](override val api: BudgetsAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Budgets.Service with AwsServiceBase[R, BudgetsImpl] {
    override val serviceName: String = "Budgets"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): BudgetsImpl[R1] = new BudgetsImpl(api, newAspect, r)
    def describeBudgetAction(request: model.DescribeBudgetActionRequest): IO[AwsError, model.DescribeBudgetActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse]("describeBudgetAction", api.describeBudgetAction)(request.buildAwsValue()).map(model.DescribeBudgetActionResponse.wrap).provide(r)
    def deleteBudget(request: model.DeleteBudgetRequest): IO[AwsError, model.DeleteBudgetResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest, software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse]("deleteBudget", api.deleteBudget)(request.buildAwsValue()).map(model.DeleteBudgetResponse.wrap).provide(r)
    def createBudget(request: model.CreateBudgetRequest): IO[AwsError, model.CreateBudgetResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.CreateBudgetRequest, software.amazon.awssdk.services.budgets.model.CreateBudgetResponse]("createBudget", api.createBudget)(request.buildAwsValue()).map(model.CreateBudgetResponse.wrap).provide(r)
    def deleteSubscriber(request: model.DeleteSubscriberRequest): IO[AwsError, model.DeleteSubscriberResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest, software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse]("deleteSubscriber", api.deleteSubscriber)(request.buildAwsValue()).map(model.DeleteSubscriberResponse.wrap).provide(r)
    def describeSubscribersForNotification(request: model.DescribeSubscribersForNotificationRequest): ZStream[Any, AwsError, model.Subscriber.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest, software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse, software.amazon.awssdk.services.budgets.model.Subscriber]("describeSubscribersForNotification", api.describeSubscribersForNotification, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.subscribers().asScala))(request.buildAwsValue()).map(item => model.Subscriber.wrap(item)).provide(r)
    def updateNotification(request: model.UpdateNotificationRequest): IO[AwsError, model.UpdateNotificationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest, software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse]("updateNotification", api.updateNotification)(request.buildAwsValue()).map(model.UpdateNotificationResponse.wrap).provide(r)
    def deleteBudgetAction(request: model.DeleteBudgetActionRequest): IO[AwsError, model.DeleteBudgetActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest, software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse]("deleteBudgetAction", api.deleteBudgetAction)(request.buildAwsValue()).map(model.DeleteBudgetActionResponse.wrap).provide(r)
    def deleteNotification(request: model.DeleteNotificationRequest): IO[AwsError, model.DeleteNotificationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest, software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse]("deleteNotification", api.deleteNotification)(request.buildAwsValue()).map(model.DeleteNotificationResponse.wrap).provide(r)
    def describeBudgetActionsForBudget(request: model.DescribeBudgetActionsForBudgetRequest): ZStream[Any, AwsError, model.Action.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse, software.amazon.awssdk.services.budgets.model.Action]("describeBudgetActionsForBudget", api.describeBudgetActionsForBudget, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.actions().asScala))(request.buildAwsValue()).map(item => model.Action.wrap(item)).provide(r)
    def updateBudget(request: model.UpdateBudgetRequest): IO[AwsError, model.UpdateBudgetResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest, software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse]("updateBudget", api.updateBudget)(request.buildAwsValue()).map(model.UpdateBudgetResponse.wrap).provide(r)
    def createBudgetAction(request: model.CreateBudgetActionRequest): IO[AwsError, model.CreateBudgetActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.CreateBudgetActionRequest, software.amazon.awssdk.services.budgets.model.CreateBudgetActionResponse]("createBudgetAction", api.createBudgetAction)(request.buildAwsValue()).map(model.CreateBudgetActionResponse.wrap).provide(r)
    def describeBudget(request: model.DescribeBudgetRequest): IO[AwsError, model.DescribeBudgetResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse]("describeBudget", api.describeBudget)(request.buildAwsValue()).map(model.DescribeBudgetResponse.wrap).provide(r)
    def describeBudgetPerformanceHistory(request: model.DescribeBudgetPerformanceHistoryRequest): IO[AwsError, model.DescribeBudgetPerformanceHistoryResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse]("describeBudgetPerformanceHistory", api.describeBudgetPerformanceHistory)(request.buildAwsValue()).map(model.DescribeBudgetPerformanceHistoryResponse.wrap).provide(r)
    def createNotification(request: model.CreateNotificationRequest): IO[AwsError, model.CreateNotificationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.CreateNotificationRequest, software.amazon.awssdk.services.budgets.model.CreateNotificationResponse]("createNotification", api.createNotification)(request.buildAwsValue()).map(model.CreateNotificationResponse.wrap).provide(r)
    def updateSubscriber(request: model.UpdateSubscriberRequest): IO[AwsError, model.UpdateSubscriberResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest, software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse]("updateSubscriber", api.updateSubscriber)(request.buildAwsValue()).map(model.UpdateSubscriberResponse.wrap).provide(r)
    def executeBudgetAction(request: model.ExecuteBudgetActionRequest): IO[AwsError, model.ExecuteBudgetActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest, software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionResponse]("executeBudgetAction", api.executeBudgetAction)(request.buildAwsValue()).map(model.ExecuteBudgetActionResponse.wrap).provide(r)
    def describeBudgets(request: model.DescribeBudgetsRequest): ZStream[Any, AwsError, model.Budget.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse, software.amazon.awssdk.services.budgets.model.Budget]("describeBudgets", api.describeBudgets, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.budgets().asScala))(request.buildAwsValue()).map(item => model.Budget.wrap(item)).provide(r)
    def describeBudgetActionsForAccount(request: model.DescribeBudgetActionsForAccountRequest): ZStream[Any, AwsError, model.Action.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse, software.amazon.awssdk.services.budgets.model.Action]("describeBudgetActionsForAccount", api.describeBudgetActionsForAccount, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.actions().asScala))(request.buildAwsValue()).map(item => model.Action.wrap(item)).provide(r)
    def createSubscriber(request: model.CreateSubscriberRequest): IO[AwsError, model.CreateSubscriberResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest, software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse]("createSubscriber", api.createSubscriber)(request.buildAwsValue()).map(model.CreateSubscriberResponse.wrap).provide(r)
    def updateBudgetAction(request: model.UpdateBudgetActionRequest): IO[AwsError, model.UpdateBudgetActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest, software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse]("updateBudgetAction", api.updateBudgetAction)(request.buildAwsValue()).map(model.UpdateBudgetActionResponse.wrap).provide(r)
    def describeNotificationsForBudget(request: model.DescribeNotificationsForBudgetRequest): ZStream[Any, AwsError, model.Notification.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest, software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse, software.amazon.awssdk.services.budgets.model.Notification]("describeNotificationsForBudget", api.describeNotificationsForBudget, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.notifications().asScala))(request.buildAwsValue()).map(item => model.Notification.wrap(item)).provide(r)
    def describeBudgetActionHistories(request: model.DescribeBudgetActionHistoriesRequest): ZStream[Any, AwsError, model.ActionHistory.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest, software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse, software.amazon.awssdk.services.budgets.model.ActionHistory]("describeBudgetActionHistories", api.describeBudgetActionHistories, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.actionHistories().asScala))(request.buildAwsValue()).map(item => model.ActionHistory.wrap(item)).provide(r)
  }
  def describeBudgetAction(request: model.DescribeBudgetActionRequest): ZIO[Budgets, AwsError, model.DescribeBudgetActionResponse.ReadOnly] = ZIO.accessM(_.get.describeBudgetAction(request))
  def deleteBudget(request: model.DeleteBudgetRequest): ZIO[Budgets, AwsError, model.DeleteBudgetResponse.ReadOnly] = ZIO.accessM(_.get.deleteBudget(request))
  def createBudget(request: model.CreateBudgetRequest): ZIO[Budgets, AwsError, model.CreateBudgetResponse.ReadOnly] = ZIO.accessM(_.get.createBudget(request))
  def deleteSubscriber(request: model.DeleteSubscriberRequest): ZIO[Budgets, AwsError, model.DeleteSubscriberResponse.ReadOnly] = ZIO.accessM(_.get.deleteSubscriber(request))
  def describeSubscribersForNotification(request: model.DescribeSubscribersForNotificationRequest): ZStream[Budgets, AwsError, model.Subscriber.ReadOnly] = ZStream.accessStream(_.get.describeSubscribersForNotification(request))
  def updateNotification(request: model.UpdateNotificationRequest): ZIO[Budgets, AwsError, model.UpdateNotificationResponse.ReadOnly] = ZIO.accessM(_.get.updateNotification(request))
  def deleteBudgetAction(request: model.DeleteBudgetActionRequest): ZIO[Budgets, AwsError, model.DeleteBudgetActionResponse.ReadOnly] = ZIO.accessM(_.get.deleteBudgetAction(request))
  def deleteNotification(request: model.DeleteNotificationRequest): ZIO[Budgets, AwsError, model.DeleteNotificationResponse.ReadOnly] = ZIO.accessM(_.get.deleteNotification(request))
  def describeBudgetActionsForBudget(request: model.DescribeBudgetActionsForBudgetRequest): ZStream[Budgets, AwsError, model.Action.ReadOnly] = ZStream.accessStream(_.get.describeBudgetActionsForBudget(request))
  def updateBudget(request: model.UpdateBudgetRequest): ZIO[Budgets, AwsError, model.UpdateBudgetResponse.ReadOnly] = ZIO.accessM(_.get.updateBudget(request))
  def createBudgetAction(request: model.CreateBudgetActionRequest): ZIO[Budgets, AwsError, model.CreateBudgetActionResponse.ReadOnly] = ZIO.accessM(_.get.createBudgetAction(request))
  def describeBudget(request: model.DescribeBudgetRequest): ZIO[Budgets, AwsError, model.DescribeBudgetResponse.ReadOnly] = ZIO.accessM(_.get.describeBudget(request))
  def describeBudgetPerformanceHistory(request: model.DescribeBudgetPerformanceHistoryRequest): ZIO[Budgets, AwsError, model.DescribeBudgetPerformanceHistoryResponse.ReadOnly] = ZIO.accessM(_.get.describeBudgetPerformanceHistory(request))
  def createNotification(request: model.CreateNotificationRequest): ZIO[Budgets, AwsError, model.CreateNotificationResponse.ReadOnly] = ZIO.accessM(_.get.createNotification(request))
  def updateSubscriber(request: model.UpdateSubscriberRequest): ZIO[Budgets, AwsError, model.UpdateSubscriberResponse.ReadOnly] = ZIO.accessM(_.get.updateSubscriber(request))
  def executeBudgetAction(request: model.ExecuteBudgetActionRequest): ZIO[Budgets, AwsError, model.ExecuteBudgetActionResponse.ReadOnly] = ZIO.accessM(_.get.executeBudgetAction(request))
  def describeBudgets(request: model.DescribeBudgetsRequest): ZStream[Budgets, AwsError, model.Budget.ReadOnly] = ZStream.accessStream(_.get.describeBudgets(request))
  def describeBudgetActionsForAccount(request: model.DescribeBudgetActionsForAccountRequest): ZStream[Budgets, AwsError, model.Action.ReadOnly] = ZStream.accessStream(_.get.describeBudgetActionsForAccount(request))
  def createSubscriber(request: model.CreateSubscriberRequest): ZIO[Budgets, AwsError, model.CreateSubscriberResponse.ReadOnly] = ZIO.accessM(_.get.createSubscriber(request))
  def updateBudgetAction(request: model.UpdateBudgetActionRequest): ZIO[Budgets, AwsError, model.UpdateBudgetActionResponse.ReadOnly] = ZIO.accessM(_.get.updateBudgetAction(request))
  def describeNotificationsForBudget(request: model.DescribeNotificationsForBudgetRequest): ZStream[Budgets, AwsError, model.Notification.ReadOnly] = ZStream.accessStream(_.get.describeNotificationsForBudget(request))
  def describeBudgetActionHistories(request: model.DescribeBudgetActionHistoriesRequest): ZStream[Budgets, AwsError, model.ActionHistory.ReadOnly] = ZStream.accessStream(_.get.describeBudgetActionHistories(request))
}