package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Subscriber(subscriptionType: SubscriptionType, address: primitives.SubscriberAddress) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Subscriber = {
    import Subscriber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Subscriber.builder().subscriptionType(subscriptionType.unwrap).address(address: java.lang.String).build()
  }
  def asReadOnly: Subscriber.ReadOnly = Subscriber.wrap(buildAwsValue())
}
object Subscriber {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Subscriber] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Subscriber = Subscriber(subscriptionTypeValue, addressValue)
    def subscriptionTypeValue: SubscriptionType
    def addressValue: primitives.SubscriberAddress
    def subscriptionType: ZIO[Any, Nothing, SubscriptionType] = ZIO.succeed(subscriptionTypeValue)
    def address: ZIO[Any, Nothing, primitives.SubscriberAddress] = ZIO.succeed(addressValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Subscriber) extends Subscriber.ReadOnly {
    override def subscriptionTypeValue: SubscriptionType = SubscriptionType.wrap(impl.subscriptionType())
    override def addressValue: primitives.SubscriberAddress = impl.address(): primitives.SubscriberAddress
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Subscriber): ReadOnly = new Wrapper(impl)
}