package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait NotificationState { def unwrap: software.amazon.awssdk.services.budgets.model.NotificationState }
object NotificationState {
  def wrap(value: software.amazon.awssdk.services.budgets.model.NotificationState): NotificationState = value match {
    case software.amazon.awssdk.services.budgets.model.NotificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.NotificationState.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.budgets.model.NotificationState.ALARM =>
      val r = ALARM
      r
  }
  case object unknownToSdkVersion extends NotificationState { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationState = software.amazon.awssdk.services.budgets.model.NotificationState.UNKNOWN_TO_SDK_VERSION }
  case object OK extends NotificationState { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationState = software.amazon.awssdk.services.budgets.model.NotificationState.OK }
  case object ALARM extends NotificationState { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationState = software.amazon.awssdk.services.budgets.model.NotificationState.ALARM }
}