package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetsResponse(budgets: scala.Option[Iterable[Budget]] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse = {
    import DescribeBudgetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse.builder().optionallyWith(budgets.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.budgets).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetsResponse.ReadOnly = DescribeBudgetsResponse.wrap(buildAwsValue())
}
object DescribeBudgetsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetsResponse = DescribeBudgetsResponse(budgetsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def budgetsValue: scala.Option[List[Budget.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def budgets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Budget.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgets", budgetsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse) extends DescribeBudgetsResponse.ReadOnly {
    override def budgetsValue: scala.Option[List[Budget.ReadOnly]] = scala.Option(impl.budgets()).map(value => value.asScala.map { item => 
      Budget.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse): ReadOnly = new Wrapper(impl)
}