package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionsForBudgetResponse(actions: Iterable[Action], nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse = {
    import DescribeBudgetActionsForBudgetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse.builder().actions(actions.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetActionsForBudgetResponse.ReadOnly = DescribeBudgetActionsForBudgetResponse.wrap(buildAwsValue())
}
object DescribeBudgetActionsForBudgetResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionsForBudgetResponse = DescribeBudgetActionsForBudgetResponse(actionsValue.map { item => 
      item.editable
    }, nextTokenValue.map(value => value))
    def actionsValue: List[Action.ReadOnly]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def actions: ZIO[Any, Nothing, List[Action.ReadOnly]] = ZIO.succeed(actionsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse) extends DescribeBudgetActionsForBudgetResponse.ReadOnly {
    override def actionsValue: List[Action.ReadOnly] = impl.actions().asScala.map { item => 
      Action.wrap(item)
    }.toList
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse): ReadOnly = new Wrapper(impl)
}