package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionsForBudgetRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, maxResults: scala.Option[primitives.MaxResults] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest = {
    import DescribeBudgetActionsForBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetActionsForBudgetRequest.ReadOnly = DescribeBudgetActionsForBudgetRequest.wrap(buildAwsValue())
}
object DescribeBudgetActionsForBudgetRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionsForBudgetRequest = DescribeBudgetActionsForBudgetRequest(accountIdValue, budgetNameValue, maxResultsValue.map(value => value), nextTokenValue.map(value => value))
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest) extends DescribeBudgetActionsForBudgetRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest): ReadOnly = new Wrapper(impl)
}