package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateBudgetRequest(accountId: primitives.AccountId, budget: Budget, notificationsWithSubscribers: scala.Option[Iterable[NotificationWithSubscribers]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.CreateBudgetRequest = {
    import CreateBudgetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CreateBudgetRequest.builder().accountId(accountId: java.lang.String).budget(budget.buildAwsValue()).optionallyWith(notificationsWithSubscribers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.notificationsWithSubscribers).build()
  }
  def asReadOnly: CreateBudgetRequest.ReadOnly = CreateBudgetRequest.wrap(buildAwsValue())
}
object CreateBudgetRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.CreateBudgetRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateBudgetRequest = CreateBudgetRequest(accountIdValue, budgetValue.editable, notificationsWithSubscribersValue.map(value => value.map { item => 
      item.editable
    }))
    def accountIdValue: primitives.AccountId
    def budgetValue: Budget.ReadOnly
    def notificationsWithSubscribersValue: scala.Option[List[NotificationWithSubscribers.ReadOnly]]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budget: ZIO[Any, Nothing, Budget.ReadOnly] = ZIO.succeed(budgetValue)
    def notificationsWithSubscribers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[NotificationWithSubscribers.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationsWithSubscribers", notificationsWithSubscribersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.CreateBudgetRequest) extends CreateBudgetRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetValue: Budget.ReadOnly = Budget.wrap(impl.budget())
    override def notificationsWithSubscribersValue: scala.Option[List[NotificationWithSubscribers.ReadOnly]] = scala.Option(impl.notificationsWithSubscribers()).map(value => value.asScala.map { item => 
      NotificationWithSubscribers.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.CreateBudgetRequest): ReadOnly = new Wrapper(impl)
}