package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ActionSubType { def unwrap: software.amazon.awssdk.services.budgets.model.ActionSubType }
object ActionSubType {
  def wrap(value: software.amazon.awssdk.services.budgets.model.ActionSubType): ActionSubType = value match {
    case software.amazon.awssdk.services.budgets.model.ActionSubType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ActionSubType.STOP_EC2_INSTANCES =>
      val r = STOP_EC2_INSTANCES
      r
    case software.amazon.awssdk.services.budgets.model.ActionSubType.STOP_RDS_INSTANCES =>
      val r = STOP_RDS_INSTANCES
      r
  }
  case object unknownToSdkVersion extends ActionSubType { override def unwrap: software.amazon.awssdk.services.budgets.model.ActionSubType = software.amazon.awssdk.services.budgets.model.ActionSubType.UNKNOWN_TO_SDK_VERSION }
  case object STOP_EC2_INSTANCES extends ActionSubType { override def unwrap: software.amazon.awssdk.services.budgets.model.ActionSubType = software.amazon.awssdk.services.budgets.model.ActionSubType.STOP_EC2_INSTANCES }
  case object STOP_RDS_INSTANCES extends ActionSubType { override def unwrap: software.amazon.awssdk.services.budgets.model.ActionSubType = software.amazon.awssdk.services.budgets.model.ActionSubType.STOP_RDS_INSTANCES }
}