package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBudgetActionResponse(accountId: primitives.AccountId, budgetName: primitives.BudgetName, oldAction: Action, newAction: Action) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse = {
    import UpdateBudgetActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).oldAction(oldAction.buildAwsValue()).newAction(newAction.buildAwsValue()).build()
  }
  def asReadOnly: UpdateBudgetActionResponse.ReadOnly = UpdateBudgetActionResponse.wrap(buildAwsValue())
}
object UpdateBudgetActionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBudgetActionResponse = UpdateBudgetActionResponse(accountIdValue, budgetNameValue, oldActionValue.editable, newActionValue.editable)
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def oldActionValue: Action.ReadOnly
    def newActionValue: Action.ReadOnly
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def oldAction: ZIO[Any, Nothing, Action.ReadOnly] = ZIO.succeed(oldActionValue)
    def newAction: ZIO[Any, Nothing, Action.ReadOnly] = ZIO.succeed(newActionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse) extends UpdateBudgetActionResponse.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def oldActionValue: Action.ReadOnly = Action.wrap(impl.oldAction())
    override def newActionValue: Action.ReadOnly = Action.wrap(impl.newAction())
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse): ReadOnly = new Wrapper(impl)
}