package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBudgetActionRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, actionId: primitives.ActionId, notificationType: scala.Option[NotificationType] = None, actionThreshold: scala.Option[ActionThreshold] = None, definition: scala.Option[Definition] = None, executionRoleArn: scala.Option[primitives.RoleArn] = None, approvalModel: scala.Option[ApprovalModel] = None, subscribers: scala.Option[Iterable[Subscriber]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest = {
    import UpdateBudgetActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).actionId(actionId: java.lang.String).optionallyWith(notificationType.map(value => value.unwrap))(_.notificationType).optionallyWith(actionThreshold.map(value => value.buildAwsValue()))(_.actionThreshold).optionallyWith(definition.map(value => value.buildAwsValue()))(_.definition).optionallyWith(executionRoleArn.map(value => value: java.lang.String))(_.executionRoleArn).optionallyWith(approvalModel.map(value => value.unwrap))(_.approvalModel).optionallyWith(subscribers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.subscribers).build()
  }
  def asReadOnly: UpdateBudgetActionRequest.ReadOnly = UpdateBudgetActionRequest.wrap(buildAwsValue())
}
object UpdateBudgetActionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBudgetActionRequest = UpdateBudgetActionRequest(accountIdValue, budgetNameValue, actionIdValue, notificationTypeValue.map(value => value), actionThresholdValue.map(value => value.editable), definitionValue.map(value => value.editable), executionRoleArnValue.map(value => value), approvalModelValue.map(value => value), subscribersValue.map(value => value.map { item => 
      item.editable
    }))
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionIdValue: primitives.ActionId
    def notificationTypeValue: scala.Option[NotificationType]
    def actionThresholdValue: scala.Option[ActionThreshold.ReadOnly]
    def definitionValue: scala.Option[Definition.ReadOnly]
    def executionRoleArnValue: scala.Option[primitives.RoleArn]
    def approvalModelValue: scala.Option[ApprovalModel]
    def subscribersValue: scala.Option[List[Subscriber.ReadOnly]]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, primitives.ActionId] = ZIO.succeed(actionIdValue)
    def notificationType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NotificationType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationType", notificationTypeValue)
    def actionThreshold: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ActionThreshold.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("actionThreshold", actionThresholdValue)
    def definition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Definition.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("definition", definitionValue)
    def executionRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("executionRoleArn", executionRoleArnValue)
    def approvalModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ApprovalModel] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("approvalModel", approvalModelValue)
    def subscribers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Subscriber.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscribers", subscribersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest) extends UpdateBudgetActionRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionIdValue: primitives.ActionId = impl.actionId(): primitives.ActionId
    override def notificationTypeValue: scala.Option[NotificationType] = scala.Option(impl.notificationType()).map(value => NotificationType.wrap(value))
    override def actionThresholdValue: scala.Option[ActionThreshold.ReadOnly] = scala.Option(impl.actionThreshold()).map(value => ActionThreshold.wrap(value))
    override def definitionValue: scala.Option[Definition.ReadOnly] = scala.Option(impl.definition()).map(value => Definition.wrap(value))
    override def executionRoleArnValue: scala.Option[primitives.RoleArn] = scala.Option(impl.executionRoleArn()).map(value => value: primitives.RoleArn)
    override def approvalModelValue: scala.Option[ApprovalModel] = scala.Option(impl.approvalModel()).map(value => ApprovalModel.wrap(value))
    override def subscribersValue: scala.Option[List[Subscriber.ReadOnly]] = scala.Option(impl.subscribers()).map(value => value.asScala.map { item => 
      Subscriber.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest): ReadOnly = new Wrapper(impl)
}