package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait NotificationType { def unwrap: software.amazon.awssdk.services.budgets.model.NotificationType }
object NotificationType {
  def wrap(value: software.amazon.awssdk.services.budgets.model.NotificationType): NotificationType = value match {
    case software.amazon.awssdk.services.budgets.model.NotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.NotificationType.ACTUAL =>
      val r = ACTUAL
      r
    case software.amazon.awssdk.services.budgets.model.NotificationType.FORECASTED =>
      val r = FORECASTED
      r
  }
  case object unknownToSdkVersion extends NotificationType { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationType = software.amazon.awssdk.services.budgets.model.NotificationType.UNKNOWN_TO_SDK_VERSION }
  case object ACTUAL extends NotificationType { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationType = software.amazon.awssdk.services.budgets.model.NotificationType.ACTUAL }
  case object FORECASTED extends NotificationType { override def unwrap: software.amazon.awssdk.services.budgets.model.NotificationType = software.amazon.awssdk.services.budgets.model.NotificationType.FORECASTED }
}