package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeBudgetActionHistoriesRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, actionId: primitives.ActionId, timePeriod: scala.Option[TimePeriod] = None, maxResults: scala.Option[primitives.MaxResults] = None, nextToken: scala.Option[primitives.GenericString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest = {
    import DescribeBudgetActionHistoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).actionId(actionId: java.lang.String).optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: DescribeBudgetActionHistoriesRequest.ReadOnly = DescribeBudgetActionHistoriesRequest.wrap(buildAwsValue())
}
object DescribeBudgetActionHistoriesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeBudgetActionHistoriesRequest = DescribeBudgetActionHistoriesRequest(accountIdValue, budgetNameValue, actionIdValue, timePeriodValue.map(value => value.editable), maxResultsValue.map(value => value), nextTokenValue.map(value => value))
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def actionIdValue: primitives.ActionId
    def timePeriodValue: scala.Option[TimePeriod.ReadOnly]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def nextTokenValue: scala.Option[primitives.GenericString]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def actionId: ZIO[Any, Nothing, primitives.ActionId] = ZIO.succeed(actionIdValue)
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TimePeriod.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest) extends DescribeBudgetActionHistoriesRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def actionIdValue: primitives.ActionId = impl.actionId(): primitives.ActionId
    override def timePeriodValue: scala.Option[TimePeriod.ReadOnly] = scala.Option(impl.timePeriod()).map(value => TimePeriod.wrap(value))
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
    override def nextTokenValue: scala.Option[primitives.GenericString] = scala.Option(impl.nextToken()).map(value => value: primitives.GenericString)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest): ReadOnly = new Wrapper(impl)
}