package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateNotificationRequest(accountId: primitives.AccountId, budgetName: primitives.BudgetName, notification: Notification, subscribers: Iterable[Subscriber]) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.CreateNotificationRequest = {
    import CreateNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.CreateNotificationRequest.builder().accountId(accountId: java.lang.String).budgetName(budgetName: java.lang.String).notification(notification.buildAwsValue()).subscribers(subscribers.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: CreateNotificationRequest.ReadOnly = CreateNotificationRequest.wrap(buildAwsValue())
}
object CreateNotificationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.CreateNotificationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateNotificationRequest = CreateNotificationRequest(accountIdValue, budgetNameValue, notificationValue.editable, subscribersValue.map { item => 
      item.editable
    })
    def accountIdValue: primitives.AccountId
    def budgetNameValue: primitives.BudgetName
    def notificationValue: Notification.ReadOnly
    def subscribersValue: List[Subscriber.ReadOnly]
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def notification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(notificationValue)
    def subscribers: ZIO[Any, Nothing, List[Subscriber.ReadOnly]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.CreateNotificationRequest) extends CreateNotificationRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def notificationValue: Notification.ReadOnly = Notification.wrap(impl.notification())
    override def subscribersValue: List[Subscriber.ReadOnly] = impl.subscribers().asScala.map { item => 
      Subscriber.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.CreateNotificationRequest): ReadOnly = new Wrapper(impl)
}