package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class BudgetPerformanceHistory(budgetName: scala.Option[primitives.BudgetName] = None, budgetType: scala.Option[BudgetType] = None, costFilters: scala.Option[Map[primitives.GenericString, Iterable[primitives.GenericString]]] = None, costTypes: scala.Option[CostTypes] = None, timeUnit: scala.Option[TimeUnit] = None, budgetedAndActualAmountsList: scala.Option[Iterable[BudgetedAndActualAmounts]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory = {
    import BudgetPerformanceHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory.builder().optionallyWith(budgetName.map(value => value: java.lang.String))(_.budgetName).optionallyWith(budgetType.map(value => value.unwrap))(_.budgetType).optionallyWith(costFilters.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item: java.lang.String
        }.asJavaCollection
    }).asJava))(_.costFilters).optionallyWith(costTypes.map(value => value.buildAwsValue()))(_.costTypes).optionallyWith(timeUnit.map(value => value.unwrap))(_.timeUnit).optionallyWith(budgetedAndActualAmountsList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.budgetedAndActualAmountsList).build()
  }
  def asReadOnly: BudgetPerformanceHistory.ReadOnly = BudgetPerformanceHistory.wrap(buildAwsValue())
}
object BudgetPerformanceHistory {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: BudgetPerformanceHistory = BudgetPerformanceHistory(budgetNameValue.map(value => value), budgetTypeValue.map(value => value), costFiltersValue.map(value => value), costTypesValue.map(value => value.editable), timeUnitValue.map(value => value), budgetedAndActualAmountsListValue.map(value => value.map { item => 
      item.editable
    }))
    def budgetNameValue: scala.Option[primitives.BudgetName]
    def budgetTypeValue: scala.Option[BudgetType]
    def costFiltersValue: scala.Option[Map[primitives.GenericString, List[primitives.GenericString]]]
    def costTypesValue: scala.Option[CostTypes.ReadOnly]
    def timeUnitValue: scala.Option[TimeUnit]
    def budgetedAndActualAmountsListValue: scala.Option[List[BudgetedAndActualAmounts.ReadOnly]]
    def budgetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BudgetName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetName", budgetNameValue)
    def budgetType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BudgetType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetType", budgetTypeValue)
    def costFilters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.GenericString, List[primitives.GenericString]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costFilters", costFiltersValue)
    def costTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostTypes.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costTypes", costTypesValue)
    def timeUnit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TimeUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timeUnit", timeUnitValue)
    def budgetedAndActualAmountsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[BudgetedAndActualAmounts.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetedAndActualAmountsList", budgetedAndActualAmountsListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory) extends BudgetPerformanceHistory.ReadOnly {
    override def budgetNameValue: scala.Option[primitives.BudgetName] = scala.Option(impl.budgetName()).map(value => value: primitives.BudgetName)
    override def budgetTypeValue: scala.Option[BudgetType] = scala.Option(impl.budgetType()).map(value => BudgetType.wrap(value))
    override def costFiltersValue: scala.Option[Map[primitives.GenericString, List[primitives.GenericString]]] = scala.Option(impl.costFilters()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.GenericString) -> value.asScala.map { item => 
          item: primitives.GenericString
        }.toList
    }).toMap)
    override def costTypesValue: scala.Option[CostTypes.ReadOnly] = scala.Option(impl.costTypes()).map(value => CostTypes.wrap(value))
    override def timeUnitValue: scala.Option[TimeUnit] = scala.Option(impl.timeUnit()).map(value => TimeUnit.wrap(value))
    override def budgetedAndActualAmountsListValue: scala.Option[List[BudgetedAndActualAmounts.ReadOnly]] = scala.Option(impl.budgetedAndActualAmountsList()).map(value => value.asScala.map { item => 
      BudgetedAndActualAmounts.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.BudgetPerformanceHistory): ReadOnly = new Wrapper(impl)
}