package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Budget(budgetName: primitives.BudgetName, budgetLimit: scala.Option[Spend] = None, plannedBudgetLimits: scala.Option[Map[primitives.GenericString, Spend]] = None, costFilters: scala.Option[Map[primitives.GenericString, Iterable[primitives.GenericString]]] = None, costTypes: scala.Option[CostTypes] = None, timeUnit: TimeUnit, timePeriod: scala.Option[TimePeriod] = None, calculatedSpend: scala.Option[CalculatedSpend] = None, budgetType: BudgetType, lastUpdatedTime: scala.Option[primitives.GenericTimestamp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Budget = {
    import Budget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Budget.builder().budgetName(budgetName: java.lang.String).optionallyWith(budgetLimit.map(value => value.buildAwsValue()))(_.budgetLimit).optionallyWith(plannedBudgetLimits.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.plannedBudgetLimits).optionallyWith(costFilters.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item: java.lang.String
        }.asJavaCollection
    }).asJava))(_.costFilters).optionallyWith(costTypes.map(value => value.buildAwsValue()))(_.costTypes).timeUnit(timeUnit.unwrap).optionallyWith(timePeriod.map(value => value.buildAwsValue()))(_.timePeriod).optionallyWith(calculatedSpend.map(value => value.buildAwsValue()))(_.calculatedSpend).budgetType(budgetType.unwrap).optionallyWith(lastUpdatedTime.map(value => value: java.time.Instant))(_.lastUpdatedTime).build()
  }
  def asReadOnly: Budget.ReadOnly = Budget.wrap(buildAwsValue())
}
object Budget {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Budget] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Budget = Budget(budgetNameValue, budgetLimitValue.map(value => value.editable), plannedBudgetLimitsValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })), costFiltersValue.map(value => value), costTypesValue.map(value => value.editable), timeUnitValue, timePeriodValue.map(value => value.editable), calculatedSpendValue.map(value => value.editable), budgetTypeValue, lastUpdatedTimeValue.map(value => value))
    def budgetNameValue: primitives.BudgetName
    def budgetLimitValue: scala.Option[Spend.ReadOnly]
    def plannedBudgetLimitsValue: scala.Option[Map[primitives.GenericString, Spend.ReadOnly]]
    def costFiltersValue: scala.Option[Map[primitives.GenericString, List[primitives.GenericString]]]
    def costTypesValue: scala.Option[CostTypes.ReadOnly]
    def timeUnitValue: TimeUnit
    def timePeriodValue: scala.Option[TimePeriod.ReadOnly]
    def calculatedSpendValue: scala.Option[CalculatedSpend.ReadOnly]
    def budgetTypeValue: BudgetType
    def lastUpdatedTimeValue: scala.Option[primitives.GenericTimestamp]
    def budgetName: ZIO[Any, Nothing, primitives.BudgetName] = ZIO.succeed(budgetNameValue)
    def budgetLimit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Spend.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("budgetLimit", budgetLimitValue)
    def plannedBudgetLimits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.GenericString, Spend.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("plannedBudgetLimits", plannedBudgetLimitsValue)
    def costFilters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.GenericString, List[primitives.GenericString]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costFilters", costFiltersValue)
    def costTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CostTypes.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("costTypes", costTypesValue)
    def timeUnit: ZIO[Any, Nothing, TimeUnit] = ZIO.succeed(timeUnitValue)
    def timePeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TimePeriod.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timePeriod", timePeriodValue)
    def calculatedSpend: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CalculatedSpend.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("calculatedSpend", calculatedSpendValue)
    def budgetType: ZIO[Any, Nothing, BudgetType] = ZIO.succeed(budgetTypeValue)
    def lastUpdatedTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericTimestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTimeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Budget) extends Budget.ReadOnly {
    override def budgetNameValue: primitives.BudgetName = impl.budgetName(): primitives.BudgetName
    override def budgetLimitValue: scala.Option[Spend.ReadOnly] = scala.Option(impl.budgetLimit()).map(value => Spend.wrap(value))
    override def plannedBudgetLimitsValue: scala.Option[Map[primitives.GenericString, Spend.ReadOnly]] = scala.Option(impl.plannedBudgetLimits()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.GenericString) -> Spend.wrap(value)
    }).toMap)
    override def costFiltersValue: scala.Option[Map[primitives.GenericString, List[primitives.GenericString]]] = scala.Option(impl.costFilters()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.GenericString) -> value.asScala.map { item => 
          item: primitives.GenericString
        }.toList
    }).toMap)
    override def costTypesValue: scala.Option[CostTypes.ReadOnly] = scala.Option(impl.costTypes()).map(value => CostTypes.wrap(value))
    override def timeUnitValue: TimeUnit = TimeUnit.wrap(impl.timeUnit())
    override def timePeriodValue: scala.Option[TimePeriod.ReadOnly] = scala.Option(impl.timePeriod()).map(value => TimePeriod.wrap(value))
    override def calculatedSpendValue: scala.Option[CalculatedSpend.ReadOnly] = scala.Option(impl.calculatedSpend()).map(value => CalculatedSpend.wrap(value))
    override def budgetTypeValue: BudgetType = BudgetType.wrap(impl.budgetType())
    override def lastUpdatedTimeValue: scala.Option[primitives.GenericTimestamp] = scala.Option(impl.lastUpdatedTime()).map(value => value: primitives.GenericTimestamp)
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Budget): ReadOnly = new Wrapper(impl)
}