package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ApprovalModel { def unwrap: software.amazon.awssdk.services.budgets.model.ApprovalModel }
object ApprovalModel {
  def wrap(value: software.amazon.awssdk.services.budgets.model.ApprovalModel): ApprovalModel = value match {
    case software.amazon.awssdk.services.budgets.model.ApprovalModel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.budgets.model.ApprovalModel.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.budgets.model.ApprovalModel.MANUAL =>
      val r = MANUAL
      r
  }
  case object unknownToSdkVersion extends ApprovalModel { override def unwrap: software.amazon.awssdk.services.budgets.model.ApprovalModel = software.amazon.awssdk.services.budgets.model.ApprovalModel.UNKNOWN_TO_SDK_VERSION }
  case object AUTOMATIC extends ApprovalModel { override def unwrap: software.amazon.awssdk.services.budgets.model.ApprovalModel = software.amazon.awssdk.services.budgets.model.ApprovalModel.AUTOMATIC }
  case object MANUAL extends ApprovalModel { override def unwrap: software.amazon.awssdk.services.budgets.model.ApprovalModel = software.amazon.awssdk.services.budgets.model.ApprovalModel.MANUAL }
}