package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SsmActionDefinition(actionSubType: ActionSubType, region: primitives.Region, instanceIds: Iterable[primitives.InstanceId]) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.SsmActionDefinition = {
    import SsmActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.SsmActionDefinition.builder().actionSubType(actionSubType.unwrap).region(region: java.lang.String).instanceIds(instanceIds.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: SsmActionDefinition.ReadOnly = SsmActionDefinition.wrap(buildAwsValue())
}
object SsmActionDefinition {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.SsmActionDefinition] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SsmActionDefinition = SsmActionDefinition(actionSubTypeValue, regionValue, instanceIdsValue)
    def actionSubTypeValue: ActionSubType
    def regionValue: primitives.Region
    def instanceIdsValue: List[primitives.InstanceId]
    def actionSubType: ZIO[Any, Nothing, ActionSubType] = ZIO.succeed(actionSubTypeValue)
    def region: ZIO[Any, Nothing, primitives.Region] = ZIO.succeed(regionValue)
    def instanceIds: ZIO[Any, Nothing, List[primitives.InstanceId]] = ZIO.succeed(instanceIdsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.SsmActionDefinition) extends SsmActionDefinition.ReadOnly {
    override def actionSubTypeValue: ActionSubType = ActionSubType.wrap(impl.actionSubType())
    override def regionValue: primitives.Region = impl.region(): primitives.Region
    override def instanceIdsValue: List[primitives.InstanceId] = impl.instanceIds().asScala.map { item => 
      item: primitives.InstanceId
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.SsmActionDefinition): ReadOnly = new Wrapper(impl)
}