package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class NotificationWithSubscribers(notification: Notification, subscribers: Iterable[Subscriber]) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers = {
    import NotificationWithSubscribers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers.builder().notification(notification.buildAwsValue()).subscribers(subscribers.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: NotificationWithSubscribers.ReadOnly = NotificationWithSubscribers.wrap(buildAwsValue())
}
object NotificationWithSubscribers {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: NotificationWithSubscribers = NotificationWithSubscribers(notificationValue.editable, subscribersValue.map { item => 
      item.editable
    })
    def notificationValue: Notification.ReadOnly
    def subscribersValue: List[Subscriber.ReadOnly]
    def notification: ZIO[Any, Nothing, Notification.ReadOnly] = ZIO.succeed(notificationValue)
    def subscribers: ZIO[Any, Nothing, List[Subscriber.ReadOnly]] = ZIO.succeed(subscribersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers) extends NotificationWithSubscribers.ReadOnly {
    override def notificationValue: Notification.ReadOnly = Notification.wrap(impl.notification())
    override def subscribersValue: List[Subscriber.ReadOnly] = impl.subscribers().asScala.map { item => 
      Subscriber.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers): ReadOnly = new Wrapper(impl)
}