package io.github.vigoo.zioaws.budgets.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Notification(notificationType: NotificationType, comparisonOperator: ComparisonOperator, threshold: primitives.NotificationThreshold, thresholdType: scala.Option[ThresholdType] = None, notificationState: scala.Option[NotificationState] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.budgets.model.Notification = {
    import Notification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.budgets.model.Notification.builder().notificationType(notificationType.unwrap).comparisonOperator(comparisonOperator.unwrap).threshold(threshold: java.lang.Double).optionallyWith(thresholdType.map(value => value.unwrap))(_.thresholdType).optionallyWith(notificationState.map(value => value.unwrap))(_.notificationState).build()
  }
  def asReadOnly: Notification.ReadOnly = Notification.wrap(buildAwsValue())
}
object Notification {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.budgets.model.Notification] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Notification = Notification(notificationTypeValue, comparisonOperatorValue, thresholdValue, thresholdTypeValue.map(value => value), notificationStateValue.map(value => value))
    def notificationTypeValue: NotificationType
    def comparisonOperatorValue: ComparisonOperator
    def thresholdValue: primitives.NotificationThreshold
    def thresholdTypeValue: scala.Option[ThresholdType]
    def notificationStateValue: scala.Option[NotificationState]
    def notificationType: ZIO[Any, Nothing, NotificationType] = ZIO.succeed(notificationTypeValue)
    def comparisonOperator: ZIO[Any, Nothing, ComparisonOperator] = ZIO.succeed(comparisonOperatorValue)
    def threshold: ZIO[Any, Nothing, primitives.NotificationThreshold] = ZIO.succeed(thresholdValue)
    def thresholdType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ThresholdType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("thresholdType", thresholdTypeValue)
    def notificationState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NotificationState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationState", notificationStateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.budgets.model.Notification) extends Notification.ReadOnly {
    override def notificationTypeValue: NotificationType = NotificationType.wrap(impl.notificationType())
    override def comparisonOperatorValue: ComparisonOperator = ComparisonOperator.wrap(impl.comparisonOperator())
    override def thresholdValue: primitives.NotificationThreshold = impl.threshold(): primitives.NotificationThreshold
    override def thresholdTypeValue: scala.Option[ThresholdType] = scala.Option(impl.thresholdType()).map(value => ThresholdType.wrap(value))
    override def notificationStateValue: scala.Option[NotificationState] = scala.Option(impl.notificationState()).map(value => NotificationState.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.budgets.model.Notification): ReadOnly = new Wrapper(impl)
}